/*
 * Decompiled with CFR 0.152.
 */
package org.anc.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.anc.Aspect;

public abstract class BaseDialog<T>
extends JDialog
implements ActionListener {
    protected JButton createButton;
    protected JButton cancelButton;
    protected boolean accepted = false;

    public BaseDialog(Frame parent, String title) {
        this(parent, title, "Ok", "Cancel");
    }

    public BaseDialog(Frame parent, String title, String okButtonText, String cancelButtonText) {
        super(parent, title, true);
        this.createButton = new JButton(okButtonText);
        this.cancelButton = new JButton(cancelButtonText);
        this.initUI();
        Aspect.center(parent, this);
    }

    public T display() {
        this.setVisible(true);
        if (this.accepted) {
            return this.getResult();
        }
        return null;
    }

    protected abstract T getResult();

    protected abstract JPanel makeMainPanel();

    @Override
    public void actionPerformed(ActionEvent event) {
        this.accepted = event.getSource() == this.createButton;
        this.setVisible(false);
    }

    private void initUI() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.makeMainPanel(), "Center");
        contentPane.add((Component)this.makeButtonPanel(), "South");
        this.pack();
    }

    private JPanel makeButtonPanel() {
        this.createButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.add(this.createButton);
        panel.add(this.cancelButton);
        return panel;
    }

    protected JLabel makeLabel(String label) {
        return new JLabel(label, 4);
    }
}

