/*
 * Decompiled with CFR 0.152.
 */
package org.anc.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.anc.ui.GBC;

public class Dialogs {
    private static Dialogs instance = null;
    public static int OK = 0;
    public static int CANCEL = 2;
    public static int YES = 0;
    public static int NO = 1;

    private Dialogs() {
    }

    public static synchronized Dialogs getInstance() {
        if (instance == null) {
            instance = new Dialogs();
        }
        return instance;
    }

    public static void messageBox(Component parent, Object message) {
        Dialogs.messageBox(parent, message, "Message");
    }

    public static void messageBox(Component parent, Object message, String title) {
        JOptionPane.showMessageDialog(parent, message, title, 1);
    }

    public static void errorBox(Component parent, Object message) {
        Dialogs.errorBox(parent, message, "Error");
    }

    public static void errorBox(Component parent, Object message, String title) {
        JOptionPane.showMessageDialog(parent, message, title, 0);
    }

    public static void errorBox(Component parent, Exception ex) {
        String title = ex.getClass().getName();
        StackTraceElement[] trace = ex.getStackTrace();
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GBC gbc = new GBC();
        gbc.anchorNorthwest();
        JTextPane pane = new JTextPane();
        pane.setLayout(new GridBagLayout());
        pane.setBackground(panel.getBackground());
        pane.setEditable(false);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < trace.length; ++i) {
            builder.append("     " + trace[i].toString() + "\n");
        }
        pane.setText("CAUSE: " + ex.getMessage() + "\n\n" + builder.toString());
        panel.add((Component)pane, gbc.down());
        JScrollPane scroll = new JScrollPane(panel);
        scroll.setPreferredSize(new Dimension(400, 250));
        Dialogs.errorBox(parent, scroll, title);
    }

    public static void warningBox(Component parent, Object message) {
        Dialogs.warningBox(parent, message, "Warning");
    }

    public static void warningBox(Component parent, Object message, String title) {
        JOptionPane.showMessageDialog(parent, message, title, 2);
    }

    public static boolean confirmBox(Component parent, Object message) {
        return Dialogs.confirmBox(parent, message, "Confirm");
    }

    public static boolean confirmBox(Component parent, Object message, String title) {
        return JOptionPane.showConfirmDialog(parent, message, title, 2) == 0;
    }

    public static boolean yesNo(Component parent, Object message) {
        return JOptionPane.showConfirmDialog(parent, message, "Confirm", 0) == 0;
    }

    public static int promptBox(Component parent, Object message) {
        return Dialogs.promptBox(parent, message, "Confirm");
    }

    public static int promptBox(Component parent, Object message, String title) {
        return JOptionPane.showConfirmDialog(parent, message, title, 0);
    }

    public static String inputBox(Component parent, Object message) {
        return Dialogs.inputBox(parent, message, "Question");
    }

    public static String inputBox(Component parent, Object message, String title) {
        return JOptionPane.showInputDialog(parent, message, title);
    }

    public static String inputBox(Component parent, Object message, String title, String defaultValue) {
        return (String)JOptionPane.showInputDialog(parent, message, title, 3, null, null, defaultValue);
    }

    public static JPanel makePanel(String[] lines) {
        GridLayout layout = new GridLayout(0, 1);
        JPanel panel = new JPanel(layout);
        for (int i = 0; i < lines.length; ++i) {
            panel.add(new JLabel(lines[i], 0));
        }
        return panel;
    }
}

