/*
 * Decompiled with CFR 0.152.
 */
package org.anc.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.anc.threads.Haltable;
import org.anc.threads.Notifiable;
import org.anc.ui.GBC;

public class ProgressDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel buttonPanel = new JPanel();
    private JPanel topPanel = new JPanel();
    private FlowLayout flowLayout1 = new FlowLayout();
    private JButton cancelButton = new JButton();
    private JProgressBar progressBar = new JProgressBar();
    private JLabel progressLabel = new JLabel();
    private Haltable haltableOwner = null;
    private Notifiable<ProgressDialog> notifiableOwner = null;

    public ProgressDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ProgressDialog() {
        this((Frame)null, "Progress", false);
    }

    public ProgressDialog(Haltable owner, String message) {
        this((Frame)null, message, false);
        this.haltableOwner = owner;
        this.progressLabel.setText(message);
    }

    public ProgressDialog(Notifiable<ProgressDialog> owner, String message) {
        this((Frame)null, message, false);
        this.notifiableOwner = owner;
        this.progressLabel.setText(message);
    }

    public void setMessage(String message) {
        this.progressLabel.setText(message);
    }

    public void setValue(int value) {
        this.progressBar.setValue(value);
    }

    public void setMax(int max) {
        this.progressBar.setMaximum(max);
    }

    public int getMax() {
        return this.progressBar.getMaximum();
    }

    public int getValue() {
        return this.progressBar.getValue();
    }

    public void reset() {
        this.progressBar.setValue(0);
    }

    public void increment() {
        int n = this.progressBar.getValue();
        this.progressBar.setValue(++n);
    }

    private void jbInit() throws Exception {
        this.setResizable(false);
        this.setTitle("Progress");
        this.buttonPanel.setLayout(this.flowLayout1);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressDialog.this.cancelButton_actionPerformed(e);
            }
        });
        this.buttonPanel.add((Component)this.cancelButton, null);
        this.progressBar.setStringPainted(true);
        this.progressBar.setPreferredSize(new Dimension(200, 20));
        this.progressLabel.setHorizontalAlignment(0);
        this.progressLabel.setText("Progress");
        this.topPanel.setLayout(new GridBagLayout());
        GBC gbc = new GBC();
        this.topPanel.add((Component)this.progressLabel, gbc);
        this.topPanel.add((Component)this.progressBar, gbc.down());
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.getContentPane().add((Component)this.topPanel, "Center");
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        if (this.haltableOwner != null) {
            this.haltableOwner.halt();
        }
        if (this.notifiableOwner != null) {
            this.notifiableOwner.signal(this);
        }
    }
}

