/*
 * Decompiled with CFR 0.152.
 */
package org.anc.util;

import java.util.Collection;
import java.util.Iterator;

public class CircularQueue<T>
implements Iterable<T> {
    private T[] storage;
    private int start;
    private int end;
    private int capacity;

    public CircularQueue() {
        this(16);
    }

    public CircularQueue(int initialCapacity) {
        if (initialCapacity <= 0) {
            initialCapacity = 16;
        }
        this.capacity = initialCapacity;
        this.storage = new Object[this.capacity];
        this.start = 0;
        this.end = 0;
    }

    public int size() {
        if (this.end < this.start) {
            return this.end + this.capacity - this.start;
        }
        return this.end - this.start;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean empty() {
        return this.start == this.end;
    }

    public void addAll(T[] items) {
        for (T item : items) {
            this.add(item);
        }
    }

    public void addAll(Collection<T> items) {
        for (T item : items) {
            this.add(item);
        }
    }

    public void add(T item) {
        if (this.size() == this.capacity - 1) {
            this.grow();
        }
        this.storage[this.end] = item;
        this.end = this.next(this.end);
    }

    public T remove() {
        if (this.empty()) {
            throw new IndexOutOfBoundsException();
        }
        T item = this.storage[this.start];
        this.start = this.next(this.start);
        return item;
    }

    @Override
    public Iterator<T> iterator() {
        return new CircularQueueIterator();
    }

    private int next(int index) {
        return (index + 1) % this.capacity;
    }

    private void grow() {
        int newCapacity = this.capacity + this.capacity;
        Object[] newStorage = new Object[newCapacity];
        int i = 0;
        while (this.start != this.end) {
            newStorage[i++] = this.storage[this.start];
            this.start = this.next(this.start);
        }
        this.storage = newStorage;
        this.capacity = newCapacity;
        this.start = 0;
        this.end = i;
    }

    public class CircularQueueIterator
    implements Iterator<T> {
        private int start;
        private int end;

        public CircularQueueIterator() {
            this.start = CircularQueue.this.start;
            this.end = CircularQueue.this.end;
        }

        @Override
        public T next() {
            if (this.start == this.end) {
                throw new IndexOutOfBoundsException();
            }
            Object item = CircularQueue.this.storage[this.start];
            this.start = CircularQueue.this.next(this.start);
            return item;
        }

        @Override
        public boolean hasNext() {
            return this.start != this.end;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

