/*
 * Decompiled with CFR 0.152.
 */
package org.anc.util;

import java.lang.reflect.Array;
import java.util.AbstractCollection;

public class Heap<T extends Comparable<T>>
extends AbstractCollection<T> {
    private static final int INITIAL_SIZE = 16;
    protected int size = 0;
    protected int capacity;
    protected Object[] heap = null;

    public Heap() {
        this(16);
    }

    public Heap(int initialSize) {
        this.capacity = initialSize;
        this.heap = new Object[this.capacity];
    }

    public Heap(Heap<T> other) {
        this.size = other.size;
        this.capacity = other.capacity;
        this.heap = (Comparable[])Array.newInstance(other.peek().getClass(), this.capacity);
        System.arraycopy(other.heap, 0, this.heap, 0, this.size);
    }

    @Override
    public java.util.Iterator<T> iterator() {
        return new Iterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(T value) {
        if (this.size + 1 >= this.capacity) {
            this.grow();
        }
        ++this.size;
        this.heap[this.size] = value;
        this.bubbleUp();
        return true;
    }

    public T remove() {
        if (0 == this.size) {
            return null;
        }
        Comparable result = (Comparable)this.heap[1];
        this.heap[1] = this.heap[this.size];
        --this.size;
        this.bubbleDown(1);
        return (T)result;
    }

    public T peek() {
        if (0 == this.size) {
            return null;
        }
        return (T)((Comparable)this.heap[1]);
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public void clear() {
        for (int i = 1; i <= this.size; ++i) {
            this.heap[i] = null;
        }
        this.size = 0;
    }

    protected void grow() {
        this.capacity += this.capacity;
        Object[] temp = new Object[this.capacity];
        System.arraycopy(this.heap, 0, temp, 0, this.heap.length);
        this.heap = temp;
    }

    protected void swap(int e1, int e2) {
        Object temp = this.heap[e1];
        this.heap[e1] = this.heap[e2];
        this.heap[e2] = temp;
    }

    protected void bubbleUp() {
        int current = this.size;
        int parent = current / 2;
        while (parent > 0 && this.compareElements(current, parent) < 0) {
            this.swap(current, parent);
            current = parent;
            parent = current / 2;
        }
    }

    protected void bubbleDown(int node) {
        int lchild = node + node;
        int rchild = lchild + 1;
        if (lchild > this.size) {
            return;
        }
        if (rchild > this.size) {
            if (this.compareElements(lchild, node) < 0) {
                this.swap(node, lchild);
                this.bubbleDown(lchild);
            }
        } else {
            int n = rchild;
            if (this.compareElements(lchild, rchild) < 0) {
                n = lchild;
            }
            if (this.compareElements(n, node) < 0) {
                this.swap(n, node);
                this.bubbleDown(n);
            }
        }
    }

    protected void dump() {
        System.out.println("Heap dump");
        for (int i = 1; i <= this.size; ++i) {
            System.out.println("" + i + " : " + this.heap[i].toString());
        }
    }

    protected int compareElements(int left, int right) {
        Comparable lhs = (Comparable)this.heap[left];
        Comparable rhs = (Comparable)this.heap[right];
        return lhs.compareTo(rhs);
    }

    class Iterator
    implements java.util.Iterator<T> {
        private int pointer = 1;

        @Override
        public boolean hasNext() {
            return this.pointer <= Heap.this.size;
        }

        @Override
        public T next() {
            Comparable result = (Comparable)Heap.this.heap[this.pointer];
            ++this.pointer;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Objects in a heap can not be remove via an Iterator object.");
        }
    }
}

