/*
 * Decompiled with CFR 0.152.
 */
package org.anc.util;

import java.util.Hashtable;
import java.util.Map;
import org.anc.util.IDCounter;

public class IDGenerator {
    protected Map<String, IDCounter> counters = new Hashtable<String, IDCounter>();
    protected int width = 0;
    private static final String zeroes = "000000000";

    public IDGenerator() {
    }

    public IDGenerator(int width) {
        this.width = width;
    }

    public synchronized String generate(String type) {
        IDCounter counter = this.counters.get(type);
        if (counter == null) {
            counter = new IDCounter();
            this.counters.put(type, counter);
        }
        String number = Integer.toString(counter.getNext());
        String pad = "";
        if (number.length() < this.width) {
            int n = this.width - number.length();
            if (n >= zeroes.length()) {
                n = zeroes.length();
            }
            pad = zeroes.substring(0, n);
        }
        return type + pad + number;
    }

    public synchronized void reset() {
        this.counters.clear();
    }

    public synchronized void reset(String type) {
        this.counters.remove(type);
    }
}

