/*
 * Decompiled with CFR 0.152.
 */
package org.anc.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import org.anc.io.UTF8Reader;
import org.anc.io.UTF8Writer;

public class Properties {
    protected HashMap<String, String> map = new HashMap();

    public void set(String key, String value) {
        if (value == null) {
            this.map.remove(key);
        } else {
            this.map.put(key, value);
        }
    }

    public String get(String key) {
        return this.map.get(key);
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }

    public Iterable<String> keys() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public void save(String path) throws UnsupportedEncodingException, FileNotFoundException {
        this.save(new UTF8Writer(path));
    }

    public void save(File file) throws UnsupportedEncodingException, FileNotFoundException {
        this.save(new UTF8Writer(file));
    }

    public void save(OutputStream stream) throws UnsupportedEncodingException {
        this.save(new UTF8Writer(stream));
    }

    protected void save(UTF8Writer utf8) {
        PrintWriter writer = new PrintWriter(utf8);
        for (String key : this.map.keySet()) {
            String value = this.map.get(key);
            if (value == null) continue;
            writer.println(key + "=" + value);
        }
        writer.close();
    }

    public void load(String path) throws IOException, UnsupportedEncodingException {
        this.load(new UTF8Reader(path));
    }

    public void load(File file) throws IOException, UnsupportedEncodingException {
        this.load(new UTF8Reader(file));
    }

    public void load(InputStream stream) throws IOException, UnsupportedEncodingException {
        this.load(new UTF8Reader(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load(UTF8Reader utf8) throws IOException {
        this.map.clear();
        BufferedReader reader = new BufferedReader(utf8);
        try {
            String line = reader.readLine();
            while (line != null) {
                if (!line.startsWith("#") && line.length() > 0) {
                    int equal = line.indexOf(61);
                    if (equal < 0) {
                        throw new IOException("Malformed properties file. No '=' found in line: " + line);
                    }
                    if (equal == line.length() - 1) {
                        throw new IOException("Malformed properties file. No value specified in line: " + line);
                    }
                    String key = line.substring(0, equal).trim();
                    String value = line.substring(equal + 1);
                    this.map.put(key, value);
                }
                line = reader.readLine();
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

