/*
 * Decompiled with CFR 0.152.
 */
package org.anc.util;

public class SimpleBuffer {
    private char[] buffer;
    private int size = 0;
    private int capacity = 64;
    private static final int GROW_SIZE = 32;

    public SimpleBuffer() {
        this.buffer = new char[this.capacity];
    }

    public SimpleBuffer(int initialCapacity) {
        this.capacity = initialCapacity;
        this.buffer = new char[this.capacity];
    }

    public void append(char[] ch, int start, int length) {
        if (this.size + length > this.capacity) {
            this.grow(this.size + length);
        }
        System.arraycopy(ch, start, this.buffer, this.size, length);
        this.size += length;
    }

    public void append(String s) {
        int len = s.length();
        int required = this.size + len;
        if (required > this.capacity) {
            this.grow(required);
        }
        System.arraycopy(s.toCharArray(), 0, this.buffer, this.size, len);
        this.size += len;
    }

    public void append(int ch) {
        this.add((char)ch);
    }

    public void add(char ch) {
        if (this.size + 1 > this.capacity) {
            this.grow(this.size + 1);
        }
        this.buffer[this.size] = ch;
        ++this.size;
    }

    protected void grow(int needed) {
        int newCap;
        for (newCap = this.capacity + 32; newCap < needed; newCap += 32) {
        }
        char[] newBuffer = new char[newCap];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.size);
        this.capacity = newCap;
        this.buffer = newBuffer;
    }

    public String toString() {
        return new String(this.buffer, 0, this.size);
    }

    public void reset() {
        this.size = 0;
    }

    public int length() {
        return this.size;
    }

    public static void main(String[] args) {
        SimpleBuffer buffer = new SimpleBuffer();
        char[] array = "This is a test.".toCharArray();
        int n = array.length;
        buffer.append(array, 0, n);
        for (int i = 0; i < 100; ++i) {
            buffer.append(array, 0, n);
        }
        System.out.println(buffer.toString());
    }
}

