/*
 * Decompiled with CFR 0.152.
 */
package org.anc.util;

import java.util.Iterator;

public class SkipList<T extends Comparable<T>>
implements Iterable<T> {
    private static final int MAX_SKIP_SIZE = 64;
    private static final int HALF_MAX = 32;
    private SkipNode<T> fHead = null;
    private long fSize = 0L;

    public long size() {
        return this.fSize;
    }

    public void clear() {
        this.fSize = 0L;
        this.fHead.delete();
    }

    public void add(T item) {
        ++this.fSize;
        if (this.fHead == null) {
            this.fHead = new SkipNode<T>(item);
            return;
        }
        SkipNode<T> block = this.findBlock(item);
        this.addToBlock(block, item);
    }

    public void replace(T item) {
        if (this.fHead == null) {
            this.add(item);
            return;
        }
        SkipNode<T> node = this.find(item);
        if (node == null) {
            this.add(item);
        } else {
            node.setItem(item);
        }
    }

    public T get(T item) {
        SkipNode<T> node = this.find(item);
        if (node == null) {
            return null;
        }
        return (T)((Comparable)node.getItem());
    }

    public SkipNode<T> find(T item) {
        SkipNode<T> block = this.findBlock(item);
        if (block == null) {
            return null;
        }
        SkipNode<T> end = block.getNextSkip();
        while (block != end) {
            if (item.compareTo(block.getItem()) == 0) {
                return block;
            }
            block = block.getNext();
        }
        return null;
    }

    public void remove(T item) {
        SkipNode<T> node = this.find(item);
        this.delete(node);
    }

    public void delete(SkipNode<T> node) {
        if (node == null) {
            return;
        }
        --this.fSize;
        assert (this.fSize >= 0L);
        SkipNode<T> prev = node.getPrev();
        SkipNode<T> next = node.getNext();
        if (node == this.fHead) {
            if (next != null) {
                assert (this.fSize == 0L);
                next.setPrev(null);
                next.setNextSkip(this.fHead.getNextSkip());
                next.setSkipSize(this.fHead.getSkipSize() - 1);
            }
            this.fHead = next;
            return;
        }
        if (prev != null) {
            prev.setNext(next);
        }
        if (next != null) {
            next.setPrev(prev);
        }
        next = node.getNextSkip();
        prev = node.getPrevSkip();
        if (next != null) {
            next.setPrevSkip(prev);
        }
        if (prev != null) {
            prev.setNextSkip(next);
            prev.setSkipSize(prev.getSkipSize() + node.getSkipSize() - 1);
            if (prev.getSkipSize() > 64) {
                this.split(prev);
            }
        }
        node = null;
    }

    @Override
    public Iterator<T> iterator() {
        return new SkipListIterator(this.fHead);
    }

    protected SkipNode<T> findBlock(T item) {
        if (this.fHead == null) {
            return null;
        }
        SkipNode<T> prev = this.fHead;
        for (SkipNode<T> block = this.fHead.getNextSkip(); block != null && item.compareTo(block.getItem()) >= 0; block = block.getNextSkip()) {
            prev = block;
        }
        return prev;
    }

    protected void addToBlock(SkipNode<T> block, T item) {
        assert (block != null);
        SkipNode<T> node = new SkipNode<T>(item);
        SkipNode<Object> current = block;
        SkipNode<T> prev = null;
        while (current != null && item.compareTo(current.getItem()) > 0) {
            prev = current;
            current = current.next;
        }
        if (prev == null) {
            if (current.getPrev() == null) {
                node.setNext(this.fHead);
                node.setNextSkip(this.fHead.getNextSkip());
                node.setSkipSize(this.fHead.getSkipSize() + 1);
                this.fHead.setPrev(node);
                this.fHead.setSkipSize(0);
                this.fHead = node;
                if (this.fHead.getSkipSize() > 64) {
                    this.split(this.fHead);
                }
            } else {
                SkipNode<T> prevNode = current.getPrev();
                SkipNode<T> prevSkip = current.getPrevSkip();
                assert (prevSkip != null);
                prevNode.setNext(node);
                prevSkip.setNextSkip(node);
                node.setPrev(prevNode);
                node.setPrevSkip(prevSkip);
                node.setNext(current);
                node.setNextSkip(current.getNextSkip());
                node.setSkipSize(current.getSkipSize() + 1);
                current.setPrev(node);
                current.setPrevSkip(null);
                current.setSkipSize(0);
                if (block.getSkipSize() > 64) {
                    this.split(block);
                }
            }
        } else {
            block.incSkipSize();
            prev.setNext(node);
            node.setPrev(prev);
            node.setNext(current);
            if (current != null) {
                current.setPrev(node);
            }
            if (block.getSkipSize() > 64) {
                this.split(block);
            }
        }
    }

    protected void split(SkipNode<T> block) {
        SkipNode<T> nextBlock = block.getNextSkip();
        SkipNode<T> midpoint = block;
        for (int i = 0; i < 32; ++i) {
            midpoint = midpoint.getNext();
        }
        midpoint.setSkipSize(block.getSkipSize() - 32);
        midpoint.setPrevSkip(block);
        midpoint.setNextSkip(nextBlock);
        block.setSkipSize(32);
        block.setNextSkip(midpoint);
        if (nextBlock != null) {
            nextBlock.setPrevSkip(midpoint);
        }
    }

    public void print() {
        for (Comparable i : this) {
            System.out.println(i);
        }
        System.out.println("Done");
    }

    public static void main(String[] args) {
        SkipList<Integer> skiplist = new SkipList<Integer>();
        skiplist.add(1);
        skiplist.add(5);
        skiplist.add(2);
        skiplist.add(10);
        skiplist.add(9);
        skiplist.add(5);
        skiplist.add(3);
        skiplist.add(4);
        skiplist.add(6);
        skiplist.add(8);
        skiplist.add(7);
        skiplist.print();
    }

    class SkipListIterator
    implements Iterator<T> {
        private SkipNode<T> iterator;

        public SkipListIterator(SkipNode<T> start) {
            this.iterator = start;
        }

        @Override
        public boolean hasNext() {
            return this.iterator != null;
        }

        @Override
        public T next() {
            Comparable result = (Comparable)this.iterator.getItem();
            this.iterator = this.iterator.getNext();
            return result;
        }

        @Override
        public void remove() {
            if (this.iterator == null) {
                return;
            }
            SkipNode node = this.iterator;
            this.iterator = this.iterator.getNext();
            SkipList.this.delete(node);
        }
    }

    public class SkipNode<T1> {
        protected SkipNode<T1> next = null;
        protected SkipNode<T1> prev = null;
        protected SkipNode<T1> nextSkip = null;
        protected SkipNode<T1> prevSkip = null;
        private T1 item;
        private int skipSize = 0;

        public SkipNode(T1 item) {
            this.item = item;
        }

        public void delete() {
            if (this.next != null) {
                this.next.delete();
            }
            this.prevSkip = null;
            this.nextSkip = null;
            this.prev = null;
            this.next = null;
        }

        public SkipNode<T1> getNext() {
            return this.next;
        }

        public SkipNode<T1> getPrev() {
            return this.prev;
        }

        public SkipNode<T1> getNextSkip() {
            return this.nextSkip;
        }

        public SkipNode<T1> getPrevSkip() {
            return this.prevSkip;
        }

        public T1 getItem() {
            return this.item;
        }

        public int getSkipSize() {
            return this.skipSize;
        }

        public void incSkipSize() {
            ++this.skipSize;
        }

        public void setNext(SkipNode<T1> next) {
            this.next = next;
        }

        public void setPrev(SkipNode<T1> prev) {
            this.prev = prev;
        }

        public void setNextSkip(SkipNode<T1> next) {
            this.nextSkip = next;
        }

        public void setPrevSkip(SkipNode<T1> prev) {
            this.prevSkip = prev;
        }

        public void setItem(T1 item) {
            this.item = item;
        }

        public void setSkipSize(int size) {
            this.skipSize = size;
        }
    }
}

