/*
 * Decompiled with CFR 0.152.
 */
package org.anc.util;

import java.util.Hashtable;
import java.util.Iterator;
import org.anc.util.Element;
import org.anc.util.Index;
import org.anc.util.SkipList;
import org.anc.util.SparseArrayIterator;

public class SparseArray<T>
implements Iterable<T> {
    private SkipList<Element<T>> fList = new SkipList();
    private Hashtable<Index, Element<T>> fTable = new Hashtable();
    private long fMaxIndex = 0L;

    public void setElementAt(long index, T value) {
        if (index > this.fMaxIndex) {
            this.fMaxIndex = index;
        }
        Element<T> e = new Element<T>(index, value);
        this.fList.replace(e);
        this.fTable.put(new Index(index), e);
    }

    public T getElementAt(long index) {
        Element<T> e = this.fTable.get(new Index(index));
        if (e == null) {
            return null;
        }
        return e.getElement();
    }

    public long size() {
        return this.fList.size();
    }

    public long getMaxIndex() {
        return this.fMaxIndex;
    }

    public void clear() {
        this.fMaxIndex = 0L;
        this.fList.clear();
        this.fTable.clear();
    }

    @Override
    public Iterator<T> iterator() {
        return new SparseArrayIterator<T>(this.fList.iterator());
    }

    public static void main(String[] args) {
        int i;
        SparseArray<Integer> sparsearray = new SparseArray<Integer>();
        for (i = 0; i < 10; ++i) {
            System.out.println("Setting element at " + (i + i));
            sparsearray.setElementAt(i + i, i);
        }
        for (i = 0; i < 10; ++i) {
            Integer j = (Integer)sparsearray.getElementAt(i + i);
            System.out.println("index " + (i + i) + ": " + j);
        }
        Iterator it = sparsearray.iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }
}

