/*
 * Decompiled with CFR 0.152.
 */
package org.anc.util.env;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import org.anc.util.Pair;
import org.anc.util.env.IEnvironmentParser;

public class WindowsEnvironmentParser
implements IEnvironmentParser {
    private static final String command = "cmd /C set";
    private LinkedList<Pair<String, String>> variables = new LinkedList();

    public WindowsEnvironmentParser() {
        this.reload();
    }

    @Override
    public Iterator<Pair<String, String>> iterator() {
        return this.variables.iterator();
    }

    public void reload() {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(command);
        }
        catch (IOException ex) {
            System.err.println("Could not execute command \"cmd /C set\" to obtain environment information.");
            ex.printStackTrace();
            return;
        }
        InputStream stream = process.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        try {
            String line = reader.readLine();
            while (line != null) {
                int equal = line.indexOf(61);
                if (equal > 0) {
                    String key = line.substring(0, equal).toLowerCase();
                    String value = line.substring(equal + 1);
                    this.variables.add(new Pair<String, String>(key, value));
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException ex) {
            System.err.println("Error parsing environment information.");
            return;
        }
    }
}

