/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.rest.spring.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JInvocation;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.handler.BaseGeneratingAnnotationHandler;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.rest.spring.annotations.Rest;
import org.androidannotations.rest.spring.helper.RestSpringValidatorHelper;
import org.androidannotations.rest.spring.holder.RestHolder;

public class RestHandler
extends BaseGeneratingAnnotationHandler<RestHolder> {
    private final RestSpringValidatorHelper restSpringValidatorHelper;

    public RestHandler(AndroidAnnotationsEnvironment environment) {
        super(Rest.class, environment);
        this.restSpringValidatorHelper = new RestSpringValidatorHelper(environment, this.getTarget());
    }

    public RestHolder createGeneratedClassHolder(AndroidAnnotationsEnvironment environment, TypeElement annotatedElement) throws Exception {
        return new RestHolder(environment, annotatedElement);
    }

    public void validate(Element element, ElementValidation validation) {
        super.validate(element, validation);
        TypeElement typeElement = (TypeElement)element;
        this.validatorHelper.notAlreadyValidated(element, validation);
        this.restSpringValidatorHelper.hasSpringAndroidJars(validation);
        this.validatorHelper.isInterface(typeElement, validation);
        this.validatorHelper.isTopLevel(typeElement, validation);
        this.validatorHelper.hasInternetPermission(this.getEnvironment().getAndroidManifest(), validation);
        this.restSpringValidatorHelper.doesNotExtendInvalidInterfaces(typeElement, validation);
        this.restSpringValidatorHelper.unannotatedMethodReturnsRestTemplate(typeElement, validation);
        this.restSpringValidatorHelper.validateConverters(element, validation);
        this.restSpringValidatorHelper.validateInterceptors(element, validation);
        this.restSpringValidatorHelper.validateRequestFactory(element, validation);
        this.restSpringValidatorHelper.validateResponseErrorHandler(element, validation);
    }

    public void process(Element element, RestHolder holder) {
        this.setRootUrl(element, holder);
        this.setConverters(element, holder);
        this.setInterceptors(element, holder);
        this.setRequestFactory(element, holder);
        this.setResponseErrorHandler(element, holder);
    }

    private void setRootUrl(Element element, RestHolder holder) {
        TypeElement typeElement = (TypeElement)element;
        String rootUrl = typeElement.getAnnotation(Rest.class).rootUrl();
        holder.getInit().body().assign((IJAssignmentTarget)holder.getRootUrlField(), (IJExpression)JExpr.lit((String)rootUrl));
    }

    private void setConverters(Element element, RestHolder holder) {
        List converters = this.annotationHelper.extractAnnotationClassArrayParameter(element, this.getTarget(), "converters");
        JFieldVar restTemplateField = holder.getRestTemplateField();
        JBlock init = holder.getInit().body();
        init.add((IJStatement)JExpr.invoke((IJExpression)restTemplateField, (String)"getMessageConverters").invoke("clear"));
        for (DeclaredType converterType : converters) {
            JInvocation newConverter = this.codeModelHelper.newBeanOrEBean(converterType, holder.getInitContextParam());
            init.add((IJStatement)JExpr.invoke((IJExpression)restTemplateField, (String)"getMessageConverters").invoke("add").arg((IJExpression)newConverter));
        }
    }

    private void setInterceptors(Element element, RestHolder holder) {
        List interceptors = this.annotationHelper.extractAnnotationClassArrayParameter(element, this.getTarget(), "interceptors");
        if (interceptors != null) {
            AbstractJClass listClass = this.getJClass(CanonicalNameConstants.ARRAYLIST);
            AbstractJClass clientInterceptorClass = this.getJClass("org.springframework.http.client.ClientHttpRequestInterceptor");
            listClass = listClass.narrow(clientInterceptorClass);
            JFieldVar restTemplateField = holder.getRestTemplateField();
            JBlock init = holder.getInit().body();
            init.add((IJStatement)JExpr.invoke((IJExpression)restTemplateField, (String)"setInterceptors").arg((IJExpression)JExpr._new((AbstractJClass)listClass)));
            for (DeclaredType interceptorType : interceptors) {
                JInvocation newInterceptor = this.codeModelHelper.newBeanOrEBean(interceptorType, holder.getInitContextParam());
                init.add((IJStatement)JExpr.invoke((IJExpression)restTemplateField, (String)"getInterceptors").invoke("add").arg((IJExpression)newInterceptor));
            }
        }
    }

    private void setRequestFactory(Element element, RestHolder holder) {
        DeclaredType requestFactoryType = this.annotationHelper.extractAnnotationClassParameter(element, this.getTarget(), "requestFactory");
        if (requestFactoryType != null) {
            JInvocation requestFactory = this.codeModelHelper.newBeanOrEBean(requestFactoryType, holder.getInitContextParam());
            holder.getInit().body().add((IJStatement)JExpr.invoke((IJExpression)holder.getRestTemplateField(), (String)"setRequestFactory").arg((IJExpression)requestFactory));
        }
    }

    private void setResponseErrorHandler(Element element, RestHolder holder) {
        DeclaredType responseErrorHandler = this.annotationHelper.extractAnnotationClassParameter(element, this.getTarget(), "responseErrorHandler");
        if (responseErrorHandler != null) {
            JInvocation errorHandler = this.codeModelHelper.newBeanOrEBean(responseErrorHandler, holder.getInitContextParam());
            holder.getInit().body().add((IJStatement)JExpr.invoke((IJExpression)holder.getRestTemplateField(), (String)"setErrorHandler").arg((IJExpression)errorHandler));
        }
    }
}

