/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.rest.spring.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JArray;
import com.helger.jcodemodel.JArrayClass;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JCatchBlock;
import com.helger.jcodemodel.JConditional;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JForEach;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JNarrowedClass;
import com.helger.jcodemodel.JOp;
import com.helger.jcodemodel.JOpBinary;
import com.helger.jcodemodel.JStringLiteral;
import com.helger.jcodemodel.JTryBlock;
import com.helger.jcodemodel.JVar;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.rest.spring.helper.RestAnnotationHelper;
import org.androidannotations.rest.spring.helper.RestSpringValidatorHelper;
import org.androidannotations.rest.spring.holder.RestHolder;

public abstract class RestMethodHandler
extends BaseAnnotationHandler<RestHolder> {
    protected final RestAnnotationHelper restAnnotationHelper;
    protected final RestSpringValidatorHelper restSpringValidatorHelper;

    public RestMethodHandler(Class<?> targetClass, AndroidAnnotationsEnvironment environment) {
        super(targetClass, environment);
        this.restAnnotationHelper = new RestAnnotationHelper(environment, this.getTarget());
        this.restSpringValidatorHelper = new RestSpringValidatorHelper(environment, this.getTarget());
    }

    public void validate(Element element, ElementValidation validation) {
        this.validatorHelper.notAlreadyValidated(element, validation);
        this.restSpringValidatorHelper.enclosingElementHasRestAnnotation(element, validation);
        this.restSpringValidatorHelper.throwsOnlyRestClientException((ExecutableElement)element, validation);
        Set<String> variableNames = this.restAnnotationHelper.extractUrlVariableNames((ExecutableElement)element);
        this.restSpringValidatorHelper.urlVariableNamesExistInParameters((ExecutableElement)element, variableNames, validation);
        this.restSpringValidatorHelper.hasAnnotatedAllParameters((ExecutableElement)element, validation);
    }

    public void process(Element element, RestHolder holder) {
        ExecutableElement executableElement = (ExecutableElement)element;
        String methodName = element.getSimpleName().toString();
        AbstractJClass methodReturnClass = this.getMethodReturnClass(element, holder);
        boolean methodReturnVoid = executableElement.getReturnType().getKind() == TypeKind.VOID;
        JMethod method = holder.getGeneratedClass().method(1, (AbstractJType)methodReturnClass, methodName);
        method.annotate(Override.class);
        SortedMap<String, JVar> params = this.addMethodParams(executableElement, holder, method);
        JBlock methodBody = new JBlock().bracesRequired(false).indentRequired(false);
        JInvocation exchangeCall = JExpr.invoke((IJExpression)holder.getRestTemplateField(), (String)"exchange");
        exchangeCall.arg(this.getUrl(element, holder));
        exchangeCall.arg(this.getHttpMethod());
        exchangeCall.arg(this.getRequestEntity(executableElement, holder, methodBody, params));
        exchangeCall.arg(this.getResponseClass(element, holder));
        IJExpression urlVariables = this.getUrlVariables(element, holder, methodBody, params);
        if (urlVariables != null) {
            exchangeCall.arg(urlVariables);
        }
        IJExpression response = this.setCookies(executableElement, holder, methodBody, exchangeCall);
        if (methodReturnVoid && response.equals(exchangeCall)) {
            methodBody.add((IJStatement)exchangeCall);
        } else if (!methodReturnVoid) {
            methodBody._return(this.addResultCallMethod(response, methodReturnClass));
        }
        methodBody = this.surroundWithRestTryCatch(holder, methodBody, methodReturnVoid);
        this.codeModelHelper.copy(methodBody, method.body());
    }

    protected AbstractJClass getMethodReturnClass(Element element, RestHolder holder) {
        ExecutableElement executableElement = (ExecutableElement)element;
        return this.codeModelHelper.typeMirrorToJClass(executableElement.getReturnType());
    }

    protected SortedMap<String, JVar> addMethodParams(ExecutableElement executableElement, RestHolder restHolder, JMethod method) {
        List<? extends VariableElement> params = executableElement.getParameters();
        TreeMap<String, JVar> methodParams = new TreeMap<String, JVar>();
        for (VariableElement variableElement : params) {
            JVar param;
            String paramName = variableElement.getSimpleName().toString();
            String paramType = variableElement.asType().toString();
            if (variableElement.asType().getKind().isPrimitive()) {
                param = method.param(this.getCodeModel().parseType(paramType), paramName);
            } else {
                AbstractJClass parameterClass = this.codeModelHelper.typeMirrorToJClass(variableElement.asType());
                param = method.param((AbstractJType)parameterClass, paramName);
            }
            methodParams.put(paramName, param);
        }
        return methodParams;
    }

    protected IJExpression getUrl(Element element, RestHolder restHolder) {
        String urlSuffix = this.getUrlSuffix(element);
        JStringLiteral url = JExpr.lit((String)this.getUrlSuffix(element));
        if (!urlSuffix.startsWith("http://") && !urlSuffix.startsWith("https://")) {
            url = JExpr.invoke((IJExpression)restHolder.getRootUrlField(), (String)"concat").arg((IJExpression)url);
        }
        return url;
    }

    protected abstract String getUrlSuffix(Element var1);

    protected IJExpression getHttpMethod() {
        AbstractJClass httpMethod = this.getJClass("org.springframework.http.HttpMethod");
        String simpleName = this.getTarget().substring(this.getTarget().lastIndexOf(46) + 1);
        String restMethodInCapitalLetters = simpleName.toUpperCase(Locale.ENGLISH);
        return httpMethod.staticRef(restMethodInCapitalLetters);
    }

    protected IJExpression getRequestEntity(ExecutableElement element, RestHolder holder, JBlock methodBody, SortedMap<String, JVar> params) {
        JVar httpHeaders = this.restAnnotationHelper.declareHttpHeaders(element, holder, methodBody);
        JVar entitySentToServer = this.restAnnotationHelper.getEntitySentToServer(element, params);
        return this.restAnnotationHelper.declareHttpEntity(methodBody, entitySentToServer, httpHeaders);
    }

    protected IJExpression getResponseClass(Element element, RestHolder holder) {
        return this.restAnnotationHelper.getResponseClass(element, holder);
    }

    protected IJExpression getUrlVariables(Element element, RestHolder holder, JBlock methodBody, SortedMap<String, JVar> params) {
        return this.restAnnotationHelper.declareUrlVariables((ExecutableElement)element, holder, methodBody, params);
    }

    protected IJExpression addResultCallMethod(IJExpression exchangeCall, AbstractJClass methodReturnClass) {
        if (methodReturnClass != null && !methodReturnClass.fullName().startsWith("org.springframework.http.ResponseEntity")) {
            return JExpr.invoke((IJExpression)exchangeCall, (String)"getBody");
        }
        return exchangeCall;
    }

    private IJExpression setCookies(ExecutableElement executableElement, RestHolder restHolder, JBlock methodBody, JInvocation exchangeCall) {
        String[] settingCookies = this.restAnnotationHelper.settingCookies(executableElement);
        if (settingCookies != null) {
            boolean methodReturnVoid = executableElement.getReturnType().getKind() == TypeKind.VOID;
            AbstractJClass exchangeResponseClass = this.restAnnotationHelper.retrieveResponseClass(executableElement.getReturnType(), restHolder);
            AbstractJClass narrowType = exchangeResponseClass == null || methodReturnVoid ? this.getCodeModel().VOID : exchangeResponseClass;
            JNarrowedClass responseEntityClass = this.getJClass("org.springframework.http.ResponseEntity").narrow((AbstractJType)narrowType);
            JVar responseEntity = methodBody.decl((AbstractJType)responseEntityClass, "response", (IJExpression)exchangeCall);
            JNarrowedClass stringListClass = this.getClasses().LIST.narrow(this.getClasses().STRING);
            JArrayClass stringArrayClass = this.getClasses().STRING.array();
            JArray cookiesArray = JExpr.newArray((AbstractJType)this.getClasses().STRING);
            for (String cookie : settingCookies) {
                cookiesArray.add((IJExpression)JExpr.lit((String)cookie));
            }
            JVar requestedCookiesVar = methodBody.decl((AbstractJType)stringArrayClass, "requestedCookies", (IJExpression)cookiesArray);
            JInvocation setCookiesList = JExpr.invoke((IJExpression)responseEntity, (String)"getHeaders").invoke("get").arg("Set-Cookie");
            JVar allCookiesList = methodBody.decl((AbstractJType)stringListClass, "allCookies", (IJExpression)setCookiesList);
            JForEach forEach = methodBody._if((IJExpression)allCookiesList.ne((IJExpression)JExpr._null()))._then().forEach((AbstractJType)this.getClasses().STRING, "rawCookie", (IJExpression)allCookiesList);
            JVar rawCookieVar = forEach.var();
            JBlock forLoopBody = forEach.body();
            JForEach innerForEach = forLoopBody.forEach((AbstractJType)this.getClasses().STRING, "thisCookieName", (IJExpression)requestedCookiesVar);
            JBlock innerBody = innerForEach.body();
            JBlock thenBlock = innerBody._if((IJExpression)JExpr.invoke((IJExpression)rawCookieVar, (String)"startsWith").arg((IJExpression)innerForEach.var().plus("=")))._then();
            JInvocation valueEnd = rawCookieVar.invoke("indexOf").arg((IJExpression)JExpr.lit((char)';'));
            JVar valueEndVar = thenBlock.decl((AbstractJType)this.getCodeModel().INT, "valueEnd", (IJExpression)valueEnd);
            JBlock fixValueEndBlock = thenBlock._if((IJExpression)valueEndVar.eq((IJExpression)JExpr.lit((int)-1)))._then();
            fixValueEndBlock.assign((IJAssignmentTarget)valueEndVar, (IJExpression)rawCookieVar.invoke("length"));
            JOpBinary indexOfValue = rawCookieVar.invoke("indexOf").arg("=").plus((IJExpression)JExpr.lit((int)1));
            JInvocation cookieValue = rawCookieVar.invoke("substring").arg((IJExpression)indexOfValue).arg((IJExpression)valueEndVar);
            thenBlock.invoke((IJExpression)restHolder.getAvailableCookiesField(), "put").arg((IJExpression)innerForEach.var()).arg((IJExpression)cookieValue);
            thenBlock._break();
            return responseEntity;
        }
        return exchangeCall;
    }

    private JBlock surroundWithRestTryCatch(RestHolder holder, JBlock block, boolean methodReturnVoid) {
        if (holder.getRestErrorHandlerField() != null) {
            JBlock newBlock = new JBlock().bracesRequired(false).indentRequired(false);
            JTryBlock tryBlock = newBlock._try();
            this.codeModelHelper.copy(block, tryBlock.body());
            JCatchBlock jCatch = tryBlock._catch(this.getJClass("org.springframework.core.NestedRuntimeException"));
            JBlock catchBlock = jCatch.body();
            JConditional conditional = catchBlock._if((IJExpression)JOp.ne((IJExpression)holder.getRestErrorHandlerField(), (IJExpression)JExpr._null()));
            JVar exceptionParam = jCatch.param("e");
            JBlock thenBlock = conditional._then();
            thenBlock.add((IJStatement)holder.getRestErrorHandlerField().invoke("onRestClientExceptionThrown").arg((IJExpression)exceptionParam));
            if (!methodReturnVoid) {
                thenBlock._return((IJExpression)JExpr._null());
            }
            conditional._else()._throw((IJExpression)exceptionParam);
            return newBlock;
        }
        return block;
    }
}

