/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.rest.spring.holder;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JAnonymousClass;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JDirectClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JOpBinary;
import com.helger.jcodemodel.JVar;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.holder.BaseGeneratedClassHolder;
import org.androidannotations.holder.GeneratedClassHolder;
import org.androidannotations.rest.spring.api.RestErrorHandler;

public class RestHolder
extends BaseGeneratedClassHolder {
    private JMethod init;
    private JVar initContextParam;
    private JFieldVar rootUrlField;
    private JFieldVar restTemplateField;
    private JFieldVar availableHeadersField;
    private JFieldVar availableCookiesField;
    private JFieldVar authenticationField;
    private JFieldVar restErrorHandlerField;

    public RestHolder(AndroidAnnotationsEnvironment environment, TypeElement annotatedElement) throws Exception {
        super(environment, annotatedElement);
        this.implementMethods();
    }

    protected void setExtends() {
        String annotatedComponentQualifiedName = this.annotatedElement.getQualifiedName().toString();
        JDirectClass annotatedComponent = this.getCodeModel().directClass(annotatedComponentQualifiedName);
        this.generatedClass._implements(this.narrow((AbstractJClass)annotatedComponent));
    }

    private void implementMethods() {
        List methods = this.codeModelHelper.getMethods(this.getAnnotatedElement());
        this.implementGetRestTemplate(methods);
        this.implementSetRestTemplate(methods);
        this.implementGetRootUrl(methods);
        this.implementSetRootUrl(methods);
        this.implementSetBasicAuth(methods);
        this.implementSetBearerAuth(methods);
        this.implementSetAuthentication(methods);
        this.implementGetCookie(methods);
        this.implementGetHeader(methods);
        this.implementSetCookie(methods);
        this.implementSetHeader(methods);
        this.implementSetErrorHandler(methods);
    }

    private void implementGetRestTemplate(List<ExecutableElement> methods) {
        JMethod getRestTemplateMethod = this.codeModelHelper.implementMethod((GeneratedClassHolder)this, methods, null, "org.springframework.web.client.RestTemplate", new String[0]);
        if (getRestTemplateMethod != null) {
            getRestTemplateMethod.body()._return((IJExpression)this.getRestTemplateField());
        }
    }

    private void implementSetRestTemplate(List<ExecutableElement> methods) {
        JMethod setRestTemplateMethod = this.codeModelHelper.implementMethod((GeneratedClassHolder)this, methods, null, TypeKind.VOID.toString(), new String[]{"org.springframework.web.client.RestTemplate"});
        if (setRestTemplateMethod != null) {
            setRestTemplateMethod.body().assign((IJAssignmentTarget)JExpr._this().ref((JVar)this.getRestTemplateField()), (IJExpression)setRestTemplateMethod.params().get(0));
        }
    }

    private void implementGetRootUrl(List<ExecutableElement> methods) {
        JMethod getRootUrlMethod = this.codeModelHelper.implementMethod((GeneratedClassHolder)this, methods, "getRootUrl", CanonicalNameConstants.STRING, new String[0]);
        if (getRootUrlMethod != null) {
            getRootUrlMethod.body()._return((IJExpression)this.getRootUrlField());
        }
    }

    private void implementSetRootUrl(List<ExecutableElement> methods) {
        JMethod setRootUrlMethod = this.codeModelHelper.implementMethod((GeneratedClassHolder)this, methods, "setRootUrl", TypeKind.VOID.toString(), new String[]{CanonicalNameConstants.STRING});
        if (setRootUrlMethod != null) {
            setRootUrlMethod.body().assign((IJAssignmentTarget)JExpr._this().ref((JVar)this.getRootUrlField()), (IJExpression)setRootUrlMethod.params().get(0));
        }
    }

    private void implementSetBasicAuth(List<ExecutableElement> methods) {
        JMethod setAuthMethod = this.codeModelHelper.implementMethod((GeneratedClassHolder)this, methods, "setHttpBasicAuth", TypeKind.VOID.toString(), new String[]{CanonicalNameConstants.STRING, CanonicalNameConstants.STRING});
        if (setAuthMethod != null) {
            AbstractJClass basicAuthClass = this.getJClass("org.springframework.http.HttpBasicAuthentication");
            JInvocation basicAuthentication = JExpr._new((AbstractJClass)basicAuthClass).arg((IJExpression)setAuthMethod.params().get(0)).arg((IJExpression)setAuthMethod.params().get(1));
            setAuthMethod.body().assign((IJAssignmentTarget)JExpr._this().ref((JVar)this.getAuthenticationField()), (IJExpression)basicAuthentication);
        }
    }

    private void implementSetBearerAuth(List<ExecutableElement> methods) {
        JMethod setBearerMethod = this.codeModelHelper.implementMethod((GeneratedClassHolder)this, methods, "setBearerAuth", TypeKind.VOID.toString(), true, new String[]{CanonicalNameConstants.STRING});
        if (setBearerMethod != null) {
            JVar tokenParamVar = (JVar)setBearerMethod.params().get(0);
            JOpBinary tokenExpr = JExpr.lit((String)"Bearer ").plus((IJExpression)tokenParamVar);
            AbstractJClass authClass = this.getJClass("org.springframework.http.HttpAuthentication");
            JAnonymousClass anonymousHttpAuthClass = this.getCodeModel().anonymousClass(authClass);
            JMethod getHeaderValueMethod = anonymousHttpAuthClass.method(1, String.class, "getHeaderValue");
            getHeaderValueMethod.annotate(Override.class);
            JBlock getHeaderValueMethodBody = getHeaderValueMethod.body();
            getHeaderValueMethodBody._return((IJExpression)tokenExpr);
            JBlock setBearerBody = setBearerMethod.body();
            setBearerBody.assign((IJAssignmentTarget)JExpr._this().ref((JVar)this.getAuthenticationField()), (IJExpression)JExpr._new((AbstractJClass)anonymousHttpAuthClass));
        }
    }

    private void implementSetAuthentication(List<ExecutableElement> methods) {
        JMethod setAuthMethod = this.codeModelHelper.implementMethod((GeneratedClassHolder)this, methods, "setAuthentication", TypeKind.VOID.toString(), new String[]{"org.springframework.http.HttpAuthentication"});
        if (setAuthMethod != null) {
            setAuthMethod.body().assign((IJAssignmentTarget)JExpr._this().ref((JVar)this.getAuthenticationField()), (IJExpression)setAuthMethod.params().get(0));
        }
    }

    private void implementGetCookie(List<ExecutableElement> methods) {
        JMethod getCookieMethod = this.codeModelHelper.implementMethod((GeneratedClassHolder)this, methods, "getCookie", CanonicalNameConstants.STRING, new String[]{CanonicalNameConstants.STRING});
        if (getCookieMethod != null) {
            JInvocation cookieValue = JExpr.invoke((IJExpression)this.getAvailableCookiesField(), (String)"get").arg((IJExpression)getCookieMethod.params().get(0));
            getCookieMethod.body()._return((IJExpression)cookieValue);
        }
    }

    private void implementGetHeader(List<ExecutableElement> methods) {
        JMethod getHeaderMethod = this.codeModelHelper.implementMethod((GeneratedClassHolder)this, methods, "getHeader", CanonicalNameConstants.STRING, new String[]{CanonicalNameConstants.STRING});
        if (getHeaderMethod != null) {
            JInvocation headerValue = JExpr.invoke((IJExpression)this.getAvailableHeadersField(), (String)"get").arg((IJExpression)getHeaderMethod.params().get(0));
            getHeaderMethod.body()._return((IJExpression)headerValue);
        }
    }

    private void implementSetCookie(List<ExecutableElement> methods) {
        JMethod setCookieMethod = this.codeModelHelper.implementMethod((GeneratedClassHolder)this, methods, "setCookie", TypeKind.VOID.toString(), new String[]{CanonicalNameConstants.STRING, CanonicalNameConstants.STRING});
        if (setCookieMethod != null) {
            setCookieMethod.body().invoke((IJExpression)this.getAvailableCookiesField(), "put").arg((IJExpression)setCookieMethod.params().get(0)).arg((IJExpression)setCookieMethod.params().get(1));
        }
    }

    private void implementSetHeader(List<ExecutableElement> methods) {
        JMethod setHeaderMethod = this.codeModelHelper.implementMethod((GeneratedClassHolder)this, methods, "setHeader", TypeKind.VOID.toString(), new String[]{CanonicalNameConstants.STRING, CanonicalNameConstants.STRING});
        if (setHeaderMethod != null) {
            setHeaderMethod.body().invoke((IJExpression)this.getAvailableHeadersField(), "put").arg((IJExpression)setHeaderMethod.params().get(0)).arg((IJExpression)setHeaderMethod.params().get(1));
        }
    }

    private void implementSetErrorHandler(List<ExecutableElement> methods) {
        JMethod setErrorHandlerMethod = this.codeModelHelper.implementMethod((GeneratedClassHolder)this, methods, "setRestErrorHandler", TypeKind.VOID.toString(), new String[]{RestErrorHandler.class.getName()});
        if (setErrorHandlerMethod != null) {
            this.setRestErrorHandlerField();
            setErrorHandlerMethod.body().assign((IJAssignmentTarget)JExpr._this().ref((JVar)this.getRestErrorHandlerField()), (IJExpression)setErrorHandlerMethod.params().get(0));
        }
    }

    public JMethod getInit() {
        if (this.init == null) {
            this.setInit();
        }
        return this.init;
    }

    public JVar getInitContextParam() {
        if (this.initContextParam == null) {
            this.setInit();
        }
        return this.initContextParam;
    }

    private void setInit() {
        this.init = this.getGeneratedClass().constructor(1);
        this.initContextParam = this.init.param((AbstractJType)this.getClasses().CONTEXT, "context");
    }

    public JFieldVar getRootUrlField() {
        if (this.rootUrlField == null) {
            this.setRootUrlField();
        }
        return this.rootUrlField;
    }

    private void setRootUrlField() {
        this.rootUrlField = this.getGeneratedClass().field(4, (AbstractJType)this.getClasses().STRING, "rootUrl");
    }

    public JFieldVar getRestTemplateField() {
        if (this.restTemplateField == null) {
            this.setRestTemplateField();
        }
        return this.restTemplateField;
    }

    private void setRestTemplateField() {
        this.restTemplateField = this.getGeneratedClass().field(4, (AbstractJType)this.getJClass("org.springframework.web.client.RestTemplate"), "restTemplate");
        this.getInit().body().assign((IJAssignmentTarget)this.restTemplateField, (IJExpression)JExpr._new((AbstractJClass)this.getJClass("org.springframework.web.client.RestTemplate")));
    }

    public JFieldVar getAvailableHeadersField() {
        if (this.availableHeadersField == null) {
            this.setAvailableHeadersField();
        }
        return this.availableHeadersField;
    }

    private void setAvailableHeadersField() {
        AbstractJClass stringClass = this.getClasses().STRING;
        AbstractJClass mapClass = this.getClasses().HASH_MAP.narrow(new AbstractJClass[]{stringClass, stringClass});
        this.availableHeadersField = this.getGeneratedClass().field(4, (AbstractJType)mapClass, "availableHeaders");
        this.getInit().body().assign((IJAssignmentTarget)this.availableHeadersField, (IJExpression)JExpr._new((AbstractJClass)mapClass));
    }

    public JFieldVar getAvailableCookiesField() {
        if (this.availableCookiesField == null) {
            this.setAvailableCookiesField();
        }
        return this.availableCookiesField;
    }

    private void setAvailableCookiesField() {
        AbstractJClass stringClass = this.getClasses().STRING;
        AbstractJClass mapClass = this.getClasses().HASH_MAP.narrow(new AbstractJClass[]{stringClass, stringClass});
        this.availableCookiesField = this.getGeneratedClass().field(4, (AbstractJType)mapClass, "availableCookies");
        this.getInit().body().assign((IJAssignmentTarget)this.availableCookiesField, (IJExpression)JExpr._new((AbstractJClass)mapClass));
    }

    public JFieldVar getAuthenticationField() {
        if (this.authenticationField == null) {
            this.setAuthenticationField();
        }
        return this.authenticationField;
    }

    private void setAuthenticationField() {
        this.authenticationField = this.getGeneratedClass().field(4, (AbstractJType)this.getJClass("org.springframework.http.HttpAuthentication"), "authentication");
    }

    public JFieldVar getRestErrorHandlerField() {
        return this.restErrorHandlerField;
    }

    private void setRestErrorHandlerField() {
        AbstractJClass restErrorHandlerClass = this.getJClass(RestErrorHandler.class.getName());
        this.restErrorHandlerField = this.getGeneratedClass().field(4, (AbstractJType)restErrorHandlerClass, "restErrorHandler");
    }
}

