/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse;

import org.androidtransfuse.scope.Scopes;
import org.androidtransfuse.util.FactoryBuilderReflectionProxy;
import org.androidtransfuse.util.GeneratedCodeRepository;
import org.androidtransfuse.util.Namer;

public final class Factories {
    public static final String FACTORIES_REPOSITORY_NAME = Namer.name("Transfuse").append("Factories").build();
    public static final String FACTORIES_PACKAGE = "org.androidtransfuse";
    public static final String IMPL_EXT = "Factory";
    private static final GeneratedCodeRepository<FactoryBuilder> REPOSITORY = new GeneratedCodeRepository<FactoryBuilder>("org.androidtransfuse", FACTORIES_REPOSITORY_NAME){

        @Override
        public FactoryBuilder findClass(Class clazz) {
            try {
                Class<?> factoryClass = Class.forName(Namer.name(clazz.getName()).append(Factories.IMPL_EXT).build());
                return new FactoryBuilderReflectionProxy(factoryClass);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
    };

    private Factories() {
    }

    public static <T> T get(Class<T> type) {
        FactoryBuilder factoryBuilder = REPOSITORY.get(type);
        return factoryBuilder.get();
    }

    public static <T> T get(Class<T> type, Scopes scopes) {
        FactoryBuilder factoryBuilder = REPOSITORY.get(type);
        return factoryBuilder.get(scopes);
    }

    public static interface FactoryBuilder<T> {
        public T get();

        public T get(Scopes var1);
    }
}

