/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.event;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.androidtransfuse.annotations.OnPause;
import org.androidtransfuse.annotations.OnResume;
import org.androidtransfuse.event.EventManager;
import org.androidtransfuse.event.EventObserver;

public final class EventTending {
    public static final String ADD_OBSERVER_METHOD = "addObserver";
    private final Map<Class, EventObserver> eventObservers = new HashMap<Class, EventObserver>();
    private final EventManager eventManager;

    @Inject
    public EventTending(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public <T> void addObserver(Class<T> event, EventObserver<T> observer) {
        this.eventObservers.put(event, observer);
    }

    @OnResume
    public void register() {
        for (Map.Entry<Class, EventObserver> observerEntry : this.eventObservers.entrySet()) {
            this.eventManager.register(observerEntry.getKey(), observerEntry.getValue());
        }
    }

    @OnPause
    public void unregister() {
        for (Map.Entry<Class, EventObserver> observerEntry : this.eventObservers.entrySet()) {
            this.eventManager.unregister(observerEntry.getValue());
        }
    }
}

