/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.androidtransfuse.util.Repository;
import org.androidtransfuse.util.TransfuseRuntimeException;

public abstract class GeneratedCodeRepository<T> {
    private ConcurrentMap<Class, T> generatedMap = new ConcurrentHashMap<Class, T>();

    public GeneratedCodeRepository(String repositoryPackage, String repositoryName) {
        this.loadRepository(this.getClass().getClassLoader(), repositoryPackage, repositoryName);
    }

    public T get(Class clazz) {
        Object result = this.generatedMap.get(clazz);
        if (result == null) {
            T value = this.findClass(clazz);
            if (value == null) {
                return null;
            }
            result = this.generatedMap.putIfAbsent(clazz, value);
            if (result == null) {
                result = value;
            }
        }
        return (T)result;
    }

    public abstract T findClass(Class var1);

    public final void loadRepository(ClassLoader classLoader, String repositoryPackage, String repositoryName) {
        try {
            Class<?> repositoryClass = classLoader.loadClass(repositoryPackage + "." + repositoryName);
            Repository instance = (Repository)repositoryClass.newInstance();
            this.generatedMap.putAll(instance.get());
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
            throw new TransfuseRuntimeException("Unable to instantiate generated Repository", e);
        }
        catch (IllegalAccessException e) {
            throw new TransfuseRuntimeException("Unable to access generated Repository", e);
        }
    }
}

