/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.scope;

import android.app.Application;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Provider;
import org.androidtransfuse.scope.Scope;
import org.androidtransfuse.scope.ScopeKey;
import org.androidtransfuse.util.TransfuseRuntimeException;

public class ApplicationScope
implements Scope {
    public static final String SEED_METHOD = "seed";
    private final ConcurrentMap<ScopeKey, Object> scopeMap = new ConcurrentHashMap<ScopeKey, Object>();

    @Override
    public <T> T getScopedObject(ScopeKey<T> key, Provider<T> provider) {
        Object value;
        Object result = this.scopeMap.get(key);
        if (result == null && (result = this.scopeMap.putIfAbsent(key, value = provider.get())) == null) {
            result = value;
        }
        return (T)result;
    }

    public <T> void seed(ScopeKey<T> key, Object object) {
        this.scopeMap.put(key, object);
    }

    public static final class ApplicationProvider
    implements Provider<Application> {
        public Application get() {
            throw new TransfuseRuntimeException("Trying to inject Application before seeded.");
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @javax.inject.Scope
    public static @interface ApplicationScopeQualifier {
    }
}

