/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.scope;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ScopeKey<T> {
    public static final String GET_METHOD = "get";
    private static final ConcurrentMap<String, ScopeKey<?>> SCOPE_CACHE = new ConcurrentHashMap();
    private final String signature;
    private final Class<T> clazz;

    private ScopeKey(Class<T> clazz, String signature) {
        if (signature == null) {
            throw new IllegalArgumentException("ScopeKey signature cannot be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("ScopeKey class cannot be null");
        }
        this.signature = signature;
        this.clazz = clazz;
    }

    public static <S> ScopeKey<S> get(Class<S> clazz, String signature) {
        ScopeKey<S> value;
        ScopeKey<S> result = (ScopeKey<S>)SCOPE_CACHE.get(signature);
        if (result == null && (result = SCOPE_CACHE.putIfAbsent(signature, value = new ScopeKey<S>(clazz, signature))) == null) {
            result = value;
        }
        return result;
    }

    public static <S> ScopeKey<S> of(Class<S> inputClazz) {
        return ScopeKey.get(inputClazz, inputClazz.getName());
    }

    public ScopeKey<T> annotatedBy(String annotation) {
        return ScopeKey.get(this.clazz, this.signature + annotation);
    }

    public String toString() {
        return this.signature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScopeKey)) {
            return false;
        }
        ScopeKey scopeKey = (ScopeKey)o;
        return this.signature.equals(scopeKey.signature);
    }

    public int hashCode() {
        return this.signature.hashCode();
    }
}

