/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.bootstrap;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.androidtransfuse.bootstrap.BootstrapInjectorReflectionProxy;
import org.androidtransfuse.scope.Scope;
import org.androidtransfuse.scope.ScopeKey;
import org.androidtransfuse.scope.Scopes;
import org.androidtransfuse.util.GeneratedCodeRepository;
import org.androidtransfuse.util.Namer;
import org.androidtransfuse.util.Providers;

public final class Bootstraps {
    public static final String BOOTSTRAPS_INJECTOR_PACKAGE = "org.androidtransfuse.bootstrap";
    public static final String BOOTSTRAPS_INJECTOR_NAME = Namer.name((String)"Bootstraps").append("Factory").build();
    public static final String BOOTSTRAPS_INJECTOR_METHOD = "inject";
    public static final String BOOTSTRAPS_INJECTOR_GET = "get";
    public static final String IMPL_EXT = "Bootstrap";
    private static final GeneratedCodeRepository<BootstrapInjector> REPOSITORY = new GeneratedCodeRepository<BootstrapInjector>("org.androidtransfuse.bootstrap", BOOTSTRAPS_INJECTOR_NAME){

        public BootstrapInjector findClass(Class clazz) {
            try {
                Class bootstrapClass = Class.forName(Namer.name((String)clazz.getName()).append(Bootstraps.IMPL_EXT).build());
                return new BootstrapInjectorReflectionProxy(bootstrapClass);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
    };

    private Bootstraps() {
    }

    public static <T> void inject(T input) {
        ((BootstrapInjector)REPOSITORY.get(input.getClass())).inject(input);
    }

    public static <T> BootstrapInjector<T> getInjector(Class<T> clazz) {
        return (BootstrapInjector)REPOSITORY.get(clazz);
    }

    public static abstract class BootstrapsInjectorAdapter<T>
    implements BootstrapInjector<T> {
        public static final String SCOPE_SINGLETONS_METHOD = "scopeSingletons";
        private final Map<Class<? extends Annotation>, Map<ScopeKey, Object>> scoped = new HashMap<Class<? extends Annotation>, Map<ScopeKey, Object>>();

        @Override
        public <S> BootstrapInjector<T> add(Class<? extends Annotation> scope, ScopeKey<S> bindType, S instance) {
            if (!this.scoped.containsKey(scope)) {
                this.scoped.put(scope, new HashMap());
            }
            this.scoped.get(scope).put(bindType, instance);
            return this;
        }

        protected void scopeSingletons(Scopes scopes) {
            for (Map.Entry<Class<? extends Annotation>, Map<ScopeKey, Object>> scopedEntry : this.scoped.entrySet()) {
                Scope scope = scopes.getScope(scopedEntry.getKey());
                if (scope == null) continue;
                for (Map.Entry<ScopeKey, Object> scopingEntry : scopedEntry.getValue().entrySet()) {
                    scope.getScopedObject(scopingEntry.getKey(), Providers.of((Object)scopingEntry.getValue()));
                }
            }
        }
    }

    public static interface BootstrapInjector<T> {
        public void inject(T var1);

        public <S> BootstrapInjector<T> add(Class<? extends Annotation> var1, ScopeKey<S> var2, S var3);
    }
}

