/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.bootstrap;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JStatement;
import javax.inject.Inject;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.adapter.ASTBase;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.ASTVoidType;
import org.androidtransfuse.analysis.astAnalyzer.ASTInjectionAspect;
import org.androidtransfuse.gen.ExceptionWrapper;
import org.androidtransfuse.gen.ExpressionMatchingIterableFactory;
import org.androidtransfuse.gen.InjectionBuilderContext;
import org.androidtransfuse.gen.InjectionExpressionBuilder;
import org.androidtransfuse.gen.InvocationBuilder;
import org.androidtransfuse.gen.variableBuilder.VariableBuilder;
import org.androidtransfuse.gen.variableDecorator.TypedExpressionFactory;
import org.androidtransfuse.model.FieldInjectionPoint;
import org.androidtransfuse.model.InjectionNode;
import org.androidtransfuse.model.MethodInjectionPoint;
import org.androidtransfuse.model.TypedExpression;
import org.androidtransfuse.transaction.TransactionRuntimeException;
import org.androidtransfuse.validation.Validator;

public class ExistingVariableInjectionBuilder
implements VariableBuilder {
    private final JExpression expression;
    private final InvocationBuilder injectionInvocationBuilder;
    private final InjectionExpressionBuilder injectionExpressionBuilder;
    private final TypedExpressionFactory typedExpressionFactory;
    private final ExceptionWrapper exceptionWrapper;
    private final ExpressionMatchingIterableFactory generatorFactory;
    private final Validator validator;

    @Inject
    public ExistingVariableInjectionBuilder(JExpression expression, InvocationBuilder injectionInvocationBuilder, InjectionExpressionBuilder injectionExpressionBuilder, TypedExpressionFactory typedExpressionFactory, ExceptionWrapper exceptionWrapper, ExpressionMatchingIterableFactory generatorFactory, Validator validator) {
        this.expression = expression;
        this.injectionInvocationBuilder = injectionInvocationBuilder;
        this.injectionExpressionBuilder = injectionExpressionBuilder;
        this.typedExpressionFactory = typedExpressionFactory;
        this.exceptionWrapper = exceptionWrapper;
        this.generatorFactory = generatorFactory;
        this.validator = validator;
    }

    public TypedExpression buildVariable(final InjectionBuilderContext injectionBuilderContext, InjectionNode injectionNode) {
        try {
            this.injectionExpressionBuilder.setupInjectionRequirements(injectionBuilderContext, injectionNode);
            ASTInjectionAspect injectionAspect = (ASTInjectionAspect)injectionNode.getAspect(ASTInjectionAspect.class);
            JBlock block = injectionBuilderContext.getBlock();
            if (injectionAspect == null) {
                this.validator.error(injectionNode.getASTType() + " injection not specified").element((ASTBase)injectionNode.getASTType()).build();
                throw new TransactionRuntimeException("Injection node not mapped: " + injectionNode.getASTType());
            }
            if (((ASTInjectionAspect)injectionNode.getAspect(ASTInjectionAspect.class)).getConstructorInjectionPoint() == null) {
                this.validator.error("Injection requires either a default no-argument constructor or an @Inject annotated constructor.").element((ASTBase)injectionNode.getASTType()).build();
                throw new TransfuseAnalysisException("No-Arg Constructor required for injection point: " + injectionNode.getClassName());
            }
            for (ASTInjectionAspect.InjectionGroup injectionGroup : injectionAspect.getGroups()) {
                for (FieldInjectionPoint fieldInjectionPoint : injectionGroup.getFieldInjectionPoints()) {
                    block.add(this.injectionInvocationBuilder.buildFieldSet((TypedExpression)injectionBuilderContext.getVariableMap().get(fieldInjectionPoint.getInjectionNode()), fieldInjectionPoint, this.expression));
                }
                for (final MethodInjectionPoint methodInjectionPoint : injectionGroup.getMethodInjectionPoints()) {
                    this.exceptionWrapper.wrapException(block, methodInjectionPoint.getThrowsTypes(), (ExceptionWrapper.BlockWriter)new ExceptionWrapper.BlockWriter<Void>(){

                        public Void write(JBlock block) throws JClassAlreadyExistsException {
                            block.add((JStatement)ExistingVariableInjectionBuilder.this.injectionInvocationBuilder.buildMethodCall((ASTType)ASTVoidType.VOID, methodInjectionPoint, (Iterable)ExistingVariableInjectionBuilder.this.generatorFactory.buildExpressionMatchingIterable(injectionBuilderContext.getVariableMap(), methodInjectionPoint.getInjectionNodes()), ExistingVariableInjectionBuilder.this.expression));
                            return null;
                        }
                    });
                }
            }
        }
        catch (JClassAlreadyExistsException e) {
            throw new TransfuseAnalysisException("JClassAlreadyExistsException while generating injection: " + injectionNode.getClassName(), (Throwable)e);
        }
        return this.typedExpressionFactory.build(injectionNode.getASTType(), this.expression);
    }
}

