/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.bootstrap;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import org.androidtransfuse.adapter.PackageClass;
import org.androidtransfuse.analysis.module.ModuleRepository;
import org.androidtransfuse.bootstrap.BootstrapException;
import org.androidtransfuse.bootstrap.Bootstraps;
import org.androidtransfuse.bootstrap.ExistingVariableInjectionBuilderFactory;
import org.androidtransfuse.gen.ClassGenerationUtil;
import org.androidtransfuse.gen.ClassNamer;
import org.androidtransfuse.gen.InjectionFragmentGenerator;
import org.androidtransfuse.gen.InstantiationStrategy;
import org.androidtransfuse.gen.InstantiationStrategyFactory;
import org.androidtransfuse.gen.ScopesGenerator;
import org.androidtransfuse.gen.UniqueVariableNamer;
import org.androidtransfuse.gen.variableBuilder.VariableBuilder;
import org.androidtransfuse.model.Aspect;
import org.androidtransfuse.model.InjectionNode;
import org.androidtransfuse.scope.Scopes;

public class BootstrapGenerator {
    private final JCodeModel codeModel;
    private final ClassGenerationUtil generationUtil;
    private final UniqueVariableNamer variableNamer;
    private final InjectionFragmentGenerator injectionGenerator;
    private final InstantiationStrategyFactory instantiationStrategyFactory;
    private final ExistingVariableInjectionBuilderFactory variableBuilderFactory;
    private final ModuleRepository repository;

    public BootstrapGenerator(JCodeModel codeModel, ClassGenerationUtil generationUtil, UniqueVariableNamer variableNamer, InjectionFragmentGenerator injectionGenerator, InstantiationStrategyFactory instantiationStrategyFactory, ExistingVariableInjectionBuilderFactory variableBuilderFactory, ModuleRepository repository) {
        this.codeModel = codeModel;
        this.generationUtil = generationUtil;
        this.variableNamer = variableNamer;
        this.injectionGenerator = injectionGenerator;
        this.instantiationStrategyFactory = instantiationStrategyFactory;
        this.variableBuilderFactory = variableBuilderFactory;
        this.repository = repository;
    }

    public JDefinedClass generate(InjectionNode injectionNode) {
        try {
            JClass nodeClass = this.generationUtil.ref(injectionNode.getASTType());
            PackageClass bootstrapClassName = ClassNamer.className((InjectionNode)injectionNode).append("Bootstrap").build();
            JDefinedClass innerInjectorClass = this.generationUtil.defineClass(bootstrapClassName);
            innerInjectorClass._extends(this.generationUtil.ref(Bootstraps.BootstrapsInjectorAdapter.class).narrow(nodeClass));
            JMethod method = innerInjectorClass.method(1, (JType)this.codeModel.VOID, "inject");
            JVar input = method.param((JType)nodeClass, this.variableNamer.generateName((JType)nodeClass));
            JBlock injectorBlock = method.body();
            JVar scopesVar = injectorBlock.decl((JType)this.generationUtil.ref(Scopes.class), this.variableNamer.generateName(Scopes.class), (JExpression)ScopesGenerator.buildScopes((ModuleRepository)this.repository, (ClassGenerationUtil)this.generationUtil));
            injectorBlock.add((JStatement)JExpr.invoke((String)"scopeSingletons").arg((JExpression)scopesVar));
            injectorBlock.invoke("inject").arg((JExpression)scopesVar).arg((JExpression)input);
            JMethod providedScopesMethod = innerInjectorClass.method(1, (JType)this.codeModel.VOID, "inject");
            JVar providedScopesVar = providedScopesMethod.param(Scopes.class, this.variableNamer.generateName(Scopes.class));
            JVar provided = providedScopesMethod.param((JType)nodeClass, this.variableNamer.generateName((JType)nodeClass));
            JBlock providedInjectorBlock = providedScopesMethod.body();
            injectionNode.addAspect(VariableBuilder.class, (Aspect)this.variableBuilderFactory.buildVariableBuilder((JExpression)provided));
            this.injectionGenerator.buildFragment(providedInjectorBlock, (InstantiationStrategy)this.instantiationStrategyFactory.buildMethodStrategy(providedInjectorBlock, (JExpression)providedScopesVar), innerInjectorClass, injectionNode, (JExpression)providedScopesVar);
            return innerInjectorClass;
        }
        catch (JClassAlreadyExistsException e) {
            throw new BootstrapException("Unable to crate Bootstrap Factory, class already exists.", e);
        }
    }
}

