/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.bootstrap;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.inject.Provider;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.androidtransfuse.AnnotationProcessorBase;
import org.androidtransfuse.SupportedAnnotations;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.element.ASTElementConverterFactory;
import org.androidtransfuse.analysis.AnalysisContext;
import org.androidtransfuse.analysis.InjectionPointFactory;
import org.androidtransfuse.analysis.module.ModuleProcessor;
import org.androidtransfuse.annotations.Factory;
import org.androidtransfuse.bootstrap.Bootstrap;
import org.androidtransfuse.bootstrap.BootstrapGenerator;
import org.androidtransfuse.bootstrap.BootstrapModule;
import org.androidtransfuse.bootstrap.BootstrapsGenerator;
import org.androidtransfuse.bootstrap.CoreFactory;
import org.androidtransfuse.bootstrap.Namespace;
import org.androidtransfuse.gen.FactoriesGenerator;
import org.androidtransfuse.gen.FactoryGenerator;
import org.androidtransfuse.model.InjectionNode;
import org.androidtransfuse.util.Providers;

@SupportedAnnotations(value={Bootstrap.class, BootstrapModule.class, Namespace.class})
public class BootstrapProcessor
extends AnnotationProcessorBase {
    private boolean ran = false;

    public boolean process(Set<? extends TypeElement> typeElements, RoundEnvironment roundEnvironment) {
        if (!this.ran) {
            try {
                Set<? extends Element> namespaceElements = roundEnvironment.getElementsAnnotatedWith(Namespace.class);
                String namespace = null;
                if (namespaceElements.size() > 0) {
                    Element namespaceElement = namespaceElements.iterator().next();
                    namespace = namespaceElement.getAnnotation(Namespace.class).value();
                }
                CoreFactory coreFactory = new CoreFactory(this.processingEnv.getElementUtils(), this.processingEnv.getMessager(), this.processingEnv.getFiler(), namespace);
                InjectionPointFactory injectionPointFactory = coreFactory.buildInjectionPointFactory();
                Collection<ASTType> moduleTypes = this.wrapASTCollection(coreFactory, roundEnvironment.getElementsAnnotatedWith(BootstrapModule.class));
                ModuleProcessor moduleProcessor = coreFactory.buildModuleProcessor();
                for (ASTType moduleType : moduleTypes) {
                    moduleProcessor.process(moduleType);
                }
                coreFactory.buildScopesGenerator().generate();
                ImmutableSet.Builder factoryTypesBuilder = ImmutableSet.builder();
                factoryTypesBuilder.addAll(this.wrapASTCollection(coreFactory, roundEnvironment.getElementsAnnotatedWith(Factory.class)));
                factoryTypesBuilder.addAll((Iterable)coreFactory.getModuleRepository().getInstalledAnnotatedWith(Factory.class));
                ImmutableSet factoryTypes = factoryTypesBuilder.build();
                coreFactory.registerFactories((Collection<? extends ASTType>)factoryTypes);
                FactoryGenerator factoryGenerator = coreFactory.buildFactoryGenerator();
                HashMap<Provider, JDefinedClass> factoryAggregate = new HashMap<Provider, JDefinedClass>();
                for (ASTType factoryType : factoryTypes) {
                    JDefinedClass generated = factoryGenerator.generate(factoryType);
                    factoryAggregate.put(Providers.of((Object)factoryType), generated);
                }
                FactoriesGenerator factoriesGenerator = coreFactory.buildFactoriesGenerator();
                factoriesGenerator.generate(factoryAggregate);
                Collection<ASTType> astTypes = this.wrapASTCollection(coreFactory, roundEnvironment.getElementsAnnotatedWith(Bootstrap.class));
                BootstrapGenerator bootstrapsInjectorGenerator = coreFactory.buildBootstrapGenerator();
                AnalysisContext context = coreFactory.buildAnalysisContext();
                HashMap<Provider, JDefinedClass> bootstrapMap = new HashMap<Provider, JDefinedClass>();
                for (ASTType astType : astTypes) {
                    InjectionNode injectionNode = injectionPointFactory.buildInjectionNode(astType, context);
                    JDefinedClass bootstrapClass = bootstrapsInjectorGenerator.generate(injectionNode);
                    bootstrapMap.put(Providers.of((Object)astType), bootstrapClass);
                }
                BootstrapsGenerator bootstrapsGenerator = coreFactory.buildBootstrapsGenerator();
                bootstrapsGenerator.generate(bootstrapMap);
                coreFactory.buildVirtualProxyGenerator().generateProxies();
                JCodeModel codeModel = coreFactory.getCodeModel();
                codeModel.build(coreFactory.buildCodeWriter(), coreFactory.buildResourceWriter());
            }
            catch (IOException e) {
                throw new TransfuseAnalysisException("Exception while writing Bootstrap class", (Throwable)e);
            }
            this.ran = true;
        }
        return true;
    }

    private Collection<ASTType> wrapASTCollection(CoreFactory coreFactory, Collection<? extends Element> elementCollection) {
        ASTElementConverterFactory converterFactory = coreFactory.buildConverterFactory();
        return Collections2.transform(elementCollection, (Function)converterFactory.buildASTElementConverter(ASTType.class));
    }
}

