/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.bootstrap;

import com.google.common.collect.ImmutableSet;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpression;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;
import org.androidtransfuse.adapter.ASTAccessModifier;
import org.androidtransfuse.adapter.ASTFactory;
import org.androidtransfuse.adapter.ASTGenericTypeWrapper;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.LazyASTTypeParameterBuilder;
import org.androidtransfuse.adapter.LazyTypeParameterBuilder;
import org.androidtransfuse.adapter.classes.ASTClassFactory;
import org.androidtransfuse.adapter.classes.LazyClassParameterBuilder;
import org.androidtransfuse.adapter.classes.LazyParametrizedTypeParameterBuilder;
import org.androidtransfuse.adapter.element.ASTElementAnnotation;
import org.androidtransfuse.adapter.element.ASTElementConverterFactory;
import org.androidtransfuse.adapter.element.ASTElementFactory;
import org.androidtransfuse.adapter.element.ASTTypeBuilderVisitor;
import org.androidtransfuse.adapter.element.ElementConverterFactory;
import org.androidtransfuse.adapter.element.LazyElementParameterBuilder;
import org.androidtransfuse.analysis.AnalysisContext;
import org.androidtransfuse.analysis.AnalysisContextFactory;
import org.androidtransfuse.analysis.Analyzer;
import org.androidtransfuse.analysis.InjectionPointFactory;
import org.androidtransfuse.analysis.astAnalyzer.ASTAnalysis;
import org.androidtransfuse.analysis.astAnalyzer.InjectionAnalyzer;
import org.androidtransfuse.analysis.astAnalyzer.ScopeAnalysis;
import org.androidtransfuse.analysis.module.BindProcessor;
import org.androidtransfuse.analysis.module.BindProviderProcessor;
import org.androidtransfuse.analysis.module.BindingConfigurationFactory;
import org.androidtransfuse.analysis.module.DefineScopeProcessor;
import org.androidtransfuse.analysis.module.InstallProcessor;
import org.androidtransfuse.analysis.module.ModuleProcessor;
import org.androidtransfuse.analysis.module.ModuleRepository;
import org.androidtransfuse.analysis.module.ProvidesProcessor;
import org.androidtransfuse.analysis.repository.InjectionNodeBuilderRepository;
import org.androidtransfuse.bootstrap.BootstrapGenerator;
import org.androidtransfuse.bootstrap.BootstrapModule;
import org.androidtransfuse.bootstrap.BootstrapProcessor;
import org.androidtransfuse.bootstrap.BootstrapsGenerator;
import org.androidtransfuse.bootstrap.ExistingVariableInjectionBuilderFactory;
import org.androidtransfuse.gen.ClassGenerationStrategy;
import org.androidtransfuse.gen.ClassGenerationUtil;
import org.androidtransfuse.gen.ClassNamer;
import org.androidtransfuse.gen.ExceptionWrapper;
import org.androidtransfuse.gen.ExpressionMatchingListFactory;
import org.androidtransfuse.gen.FactoriesGenerator;
import org.androidtransfuse.gen.FactoryGenerator;
import org.androidtransfuse.gen.FieldInstantiationStrategy;
import org.androidtransfuse.gen.FilerResourceWriter;
import org.androidtransfuse.gen.FilerSourceCodeWriter;
import org.androidtransfuse.gen.InjectionBuilderContext;
import org.androidtransfuse.gen.InjectionBuilderContextFactory;
import org.androidtransfuse.gen.InjectionExpressionBuilder;
import org.androidtransfuse.gen.InjectionFragmentGenerator;
import org.androidtransfuse.gen.InstantiationStrategy;
import org.androidtransfuse.gen.InstantiationStrategyFactory;
import org.androidtransfuse.gen.InvocationBuilder;
import org.androidtransfuse.gen.MethodInstantiationStrategy;
import org.androidtransfuse.gen.ProviderGenerator;
import org.androidtransfuse.gen.ScopesGenerator;
import org.androidtransfuse.gen.UniqueVariableNamer;
import org.androidtransfuse.gen.componentBuilder.InjectionNodeImplFactory;
import org.androidtransfuse.gen.componentBuilder.MirroredMethodGeneratorFactory;
import org.androidtransfuse.gen.invocationBuilder.InvocationBuilderStrategy;
import org.androidtransfuse.gen.invocationBuilder.ModifiedInvocationBuilder;
import org.androidtransfuse.gen.invocationBuilder.PrivateInvocationBuilder;
import org.androidtransfuse.gen.invocationBuilder.PublicInvocationBuilder;
import org.androidtransfuse.gen.invocationBuilder.TypeInvocationHelper;
import org.androidtransfuse.gen.proxy.AOPProxyGenerator;
import org.androidtransfuse.gen.proxy.VirtualProxyGenerator;
import org.androidtransfuse.gen.scopeBuilder.CustomScopeAspectFactoryFactory;
import org.androidtransfuse.gen.scopeBuilder.ScopeAspectFactory;
import org.androidtransfuse.gen.scopeBuilder.SingletonScopeAspectFactory;
import org.androidtransfuse.gen.variableBuilder.FactoryNodeBuilder;
import org.androidtransfuse.gen.variableBuilder.InjectionNodeBuilder;
import org.androidtransfuse.gen.variableBuilder.ProviderInjectionNodeBuilderFactory;
import org.androidtransfuse.gen.variableBuilder.ProviderVariableBuilderFactory;
import org.androidtransfuse.gen.variableBuilder.ProvidesInjectionNodeBuilderFactory;
import org.androidtransfuse.gen.variableBuilder.ProvidesVariableBuilderFactory;
import org.androidtransfuse.gen.variableBuilder.ProxyVariableBuilder;
import org.androidtransfuse.gen.variableBuilder.ScopeReferenceInjectionFactory;
import org.androidtransfuse.gen.variableBuilder.ScopesInjectionNodeBuilder;
import org.androidtransfuse.gen.variableBuilder.VariableASTImplementationFactory;
import org.androidtransfuse.gen.variableBuilder.VariableFactoryBuilderFactory2;
import org.androidtransfuse.gen.variableBuilder.VariableInjectionBuilder;
import org.androidtransfuse.gen.variableBuilder.VariableInjectionNodeBuilder;
import org.androidtransfuse.gen.variableDecorator.CachedExpressionDecorator;
import org.androidtransfuse.gen.variableDecorator.ExpressionDecoratorFactory;
import org.androidtransfuse.gen.variableDecorator.GeneratedProviderBuilderFactory;
import org.androidtransfuse.gen.variableDecorator.GeneratedProviderInjectionNodeBuilder;
import org.androidtransfuse.gen.variableDecorator.ScopedExpressionDecorator;
import org.androidtransfuse.gen.variableDecorator.TypedExpressionFactory;
import org.androidtransfuse.gen.variableDecorator.VariableBuilderExpressionDecorator;
import org.androidtransfuse.gen.variableDecorator.VariableExpressionBuilder;
import org.androidtransfuse.gen.variableDecorator.VariableExpressionBuilderFactory;
import org.androidtransfuse.gen.variableDecorator.VirtualProxyExpressionDecorator;
import org.androidtransfuse.model.InjectionNode;
import org.androidtransfuse.model.TypedExpression;
import org.androidtransfuse.scope.ConcurrentDoubleLockingScope;
import org.androidtransfuse.scope.Scopes;
import org.androidtransfuse.util.Generated;
import org.androidtransfuse.util.JavaAnnotationPredicate;
import org.androidtransfuse.util.Logger;
import org.androidtransfuse.util.MessagerLogger;
import org.androidtransfuse.util.Providers;
import org.androidtransfuse.util.QualifierPredicate;
import org.androidtransfuse.util.ScopePredicate;
import org.androidtransfuse.util.VirtualProxyException;
import org.androidtransfuse.validation.Validator;

public class CoreFactory {
    private final Elements elements;
    private final JCodeModel codeModel = new JCodeModel();
    private final VirtualProxyGenerator.VirtualProxyGeneratorCache virtualProxyCache;
    private final ASTClassFactory astClassFactory = new ASTClassFactory((ASTFactory)new ConcreteASTFactory());
    private final TypedExpressionFactory typedExpressionFactory = new TypedExpressionFactory(this.astClassFactory);
    private final UniqueVariableNamer variableNamer = new UniqueVariableNamer();
    private final ClassNamer classNamer;
    private final ClassGenerationUtil generationUtil;
    private final ProviderGenerator.ProviderCache providerCache = new ProviderGenerator.ProviderCache();
    private final Filer filer;
    private final ModuleRepositoryImpl moduleRepository = new ModuleRepositoryImpl();
    private final Validator validator;
    private final ScopePredicate scopePredicate = new ScopePredicate(this.astClassFactory);
    private final InstantiationStrategyFactory instantiationStrategyFactory = new InstantiationStrategyFactoryImpl();
    private final Logger log;
    private BootstrapGenerator bootstrapGenerator = null;

    public CoreFactory(Elements elements, Messager messager, Filer filer, String namespace) {
        this.log = new MessagerLogger(messager, false);
        this.elements = elements;
        this.filer = filer;
        this.classNamer = new ClassNamer(namespace);
        this.validator = new Validator("Bootstrap: ", messager);
        this.generationUtil = new ClassGenerationUtil(this.codeModel, new ClassGenerationStrategy(Generated.class, BootstrapProcessor.class.getName()), this.validator);
        this.virtualProxyCache = new VirtualProxyGenerator.VirtualProxyGeneratorCache(this.classNamer);
        this.moduleRepository.addModuleRepository(this.buildScopeRepository());
    }

    public ASTElementConverterFactory buildConverterFactory() {
        ConcreteASTFactory astFactory = new ConcreteASTFactory();
        ASTElementFactoryVProxy astElementFactoryProvider = new ASTElementFactoryVProxy();
        ASTTypeBuilderVisitor astTypeBuilderVisitor = new ASTTypeBuilderVisitor((Provider)astElementFactoryProvider);
        ElementConverterFactory elementConverterFactory = new ElementConverterFactory(astTypeBuilderVisitor, (Provider)astElementFactoryProvider, (ASTFactory)astFactory);
        ASTElementConverterFactory astElementConverterFactory = new ASTElementConverterFactory(elementConverterFactory);
        astFactory.setElementConverterFactory(elementConverterFactory);
        astFactory.setAstElementFactoryProvider(astElementFactoryProvider);
        astElementFactoryProvider.load((Provider<ASTElementFactory>)Providers.of((Object)new ASTElementFactory(this.elements, (ASTFactory)astFactory, astTypeBuilderVisitor, astElementConverterFactory, this.log)));
        return astElementConverterFactory;
    }

    public InjectionPointFactory buildInjectionPointFactory() {
        QualifierPredicate qualifierPredicate = new QualifierPredicate(this.astClassFactory);
        return new InjectionPointFactory(this.astClassFactory, qualifierPredicate, new VariableInjectionNodeBuilder(this.buildAnalyser(), this.buildVariableInjectionBuilder()), (Provider)new GeneratedProviderInjectionNodeBuilderProvider());
    }

    public ScopesGenerator buildScopesGenerator() {
        return new ScopesGenerator(this.generationUtil, this.getModuleRepository());
    }

    public BootstrapsGenerator buildBootstrapsGenerator() {
        return new BootstrapsGenerator(this.generationUtil, this.variableNamer);
    }

    private VariableInjectionBuilder buildVariableInjectionBuilder() {
        AOPProxyGenerator aopProxyGenerator = new AOPProxyGenerator(this.variableNamer, this.classNamer, this.generationUtil, this.validator);
        InjectionExpressionBuilder injectionExpressionBuilder = new InjectionExpressionBuilder();
        injectionExpressionBuilder.setExpressionDecorator(new ExpressionDecoratorFactory((VariableExpressionBuilderFactory)new ConcreteVariableExpressionBuilderFactory()).get());
        ExceptionWrapper exceptionWrapper = new ExceptionWrapper(this.generationUtil);
        ExpressionMatchingListFactory generatorFactory = new ExpressionMatchingListFactory(new TypeInvocationHelper(this.astClassFactory, this.generationUtil));
        return new VariableInjectionBuilder(this.generationUtil, this.variableNamer, this.buildInvocationBuilder(), aopProxyGenerator, injectionExpressionBuilder, this.typedExpressionFactory, exceptionWrapper, generatorFactory, this.validator);
    }

    private Analyzer buildAnalyser() {
        Analyzer analyzer = new Analyzer();
        analyzer.setVariableInjectionBuilderProvider(Providers.of((Object)this.buildVariableInjectionBuilder()));
        analyzer.setLog(this.log);
        return analyzer;
    }

    public AnalysisContext buildAnalysisContext() {
        return new AnalysisContext(this.buildInjectionNodeRepository());
    }

    private Provider<InjectionNodeBuilderRepository> buildInjectionNodeRepositoryProvider() {
        return new Provider<InjectionNodeBuilderRepository>(){

            public InjectionNodeBuilderRepository get() {
                return CoreFactory.this.buildInjectionNodeRepository();
            }
        };
    }

    private InjectionNodeBuilderRepository buildInjectionNodeRepository() {
        return this.moduleRepository.buildModuleConfiguration();
    }

    private GeneratedProviderInjectionNodeBuilder buildGeneratedProviderInjectionNodeBuilder() {
        Provider<ProviderGenerator> providerGeneratorProvider = new Provider<ProviderGenerator>(){

            public ProviderGenerator get() {
                return CoreFactory.this.buildProviderGenerator();
            }
        };
        GeneratedProviderBuilderFactory generatedProviderBuilderFactory = new GeneratedProviderBuilderFactory((Provider)providerGeneratorProvider, Providers.of((Object)this.typedExpressionFactory));
        return new GeneratedProviderInjectionNodeBuilder(generatedProviderBuilderFactory, this.buildInjectionPointFactory(), this.buildAnalyser());
    }

    private ProviderGenerator buildProviderGenerator() {
        return new ProviderGenerator(this.providerCache, this.buildInjectionGenerator(), this.instantiationStrategyFactory, this.generationUtil, this.variableNamer, this.classNamer);
    }

    private Set<ASTAnalysis> buildAnalysisRepository() {
        HashSet<ASTAnalysis> analysisRepository = new HashSet<ASTAnalysis>();
        analysisRepository.add((ASTAnalysis)new InjectionAnalyzer(this.buildInjectionPointFactory()));
        analysisRepository.add((ASTAnalysis)new ScopeAnalysis(this.scopePredicate, this.validator));
        return analysisRepository;
    }

    private InjectionNodeBuilderRepository buildScopeRepository() {
        InjectionNodeBuilderRepository scopeRepository = new InjectionNodeBuilderRepository(this.buildAnalysisRepository(), this.astClassFactory);
        scopeRepository.putScopeAspectFactory(this.astClassFactory.getType(Singleton.class), this.astClassFactory.getType(ConcurrentDoubleLockingScope.class), (ScopeAspectFactory)new SingletonScopeAspectFactory(this.buildVariableFactoryBuilderFactory(), this.astClassFactory));
        scopeRepository.putScopeAspectFactory(this.astClassFactory.getType(BootstrapModule.class), this.astClassFactory.getType(ConcurrentDoubleLockingScope.class), (ScopeAspectFactory)new SingletonScopeAspectFactory(this.buildVariableFactoryBuilderFactory(), this.astClassFactory));
        scopeRepository.putType(Scopes.class, (InjectionNodeBuilder)new ScopesInjectionNodeBuilder(this.buildAnalyser(), this.typedExpressionFactory));
        return scopeRepository;
    }

    private InvocationBuilder buildInvocationBuilder() {
        return new InvocationBuilder(new InvocationBuilderStrategy(){

            public ModifiedInvocationBuilder getInjectionBuilder(ASTAccessModifier modifier) {
                if (modifier.equals((Object)ASTAccessModifier.PUBLIC)) {
                    return new PublicInvocationBuilder(new TypeInvocationHelper(CoreFactory.this.astClassFactory, CoreFactory.this.generationUtil), CoreFactory.this.generationUtil);
                }
                return new PrivateInvocationBuilder(CoreFactory.this.generationUtil);
            }
        });
    }

    public JCodeModel getCodeModel() {
        return this.codeModel;
    }

    public CodeWriter buildCodeWriter() {
        return new FilerSourceCodeWriter(this.filer);
    }

    public CodeWriter buildResourceWriter() {
        return new FilerResourceWriter(this.filer);
    }

    private InjectionFragmentGenerator buildInjectionGenerator() {
        InjectionBuilderContextFactoryImpl injectionBuilderContextFactory = new InjectionBuilderContextFactoryImpl();
        InjectionExpressionBuilder injectionExpressionBuilder = new InjectionExpressionBuilder();
        injectionExpressionBuilder.setExpressionDecorator(new ExpressionDecoratorFactory((VariableExpressionBuilderFactory)new ConcreteVariableExpressionBuilderFactory()).get());
        VirtualProxyGenerator virtualProxyGenerator = new VirtualProxyGenerator(this.codeModel, this.variableNamer, this.astClassFactory, this.generationUtil, this.virtualProxyCache);
        return new InjectionFragmentGenerator((InjectionBuilderContextFactory)injectionBuilderContextFactory, injectionExpressionBuilder, virtualProxyGenerator);
    }

    public synchronized BootstrapGenerator buildBootstrapGenerator() {
        if (this.bootstrapGenerator == null) {
            InjectionExpressionBuilder injectionExpressionBuilder = new InjectionExpressionBuilder();
            injectionExpressionBuilder.setExpressionDecorator(new ExpressionDecoratorFactory((VariableExpressionBuilderFactory)new ConcreteVariableExpressionBuilderFactory()).get());
            ExistingVariableInjectionBuilderFactory variableBuilderFactory = new ExistingVariableInjectionBuilderFactory(this.buildInvocationBuilder(), injectionExpressionBuilder, this.typedExpressionFactory, new ExceptionWrapper(this.generationUtil), new ExpressionMatchingListFactory(new TypeInvocationHelper(this.astClassFactory, this.generationUtil)), this.validator);
            this.bootstrapGenerator = new BootstrapGenerator(this.codeModel, this.generationUtil, this.variableNamer, this.buildInjectionGenerator(), this.instantiationStrategyFactory, variableBuilderFactory, this.getModuleRepository());
        }
        return this.bootstrapGenerator;
    }

    public ModuleProcessor buildModuleProcessor() {
        VariableASTImplementationFactory variableASTImplementationFactory = new VariableASTImplementationFactory(this.buildAnalyser(), Providers.of((Object)this.buildVariableInjectionBuilder()));
        InjectionExpressionBuilder injectionExpressionBuilder = new InjectionExpressionBuilder();
        injectionExpressionBuilder.setExpressionDecorator(new ExpressionDecoratorFactory((VariableExpressionBuilderFactory)new ConcreteVariableExpressionBuilderFactory()).get());
        ProvidesVariableBuilderFactory providesVariableBuilderFactory = new ProvidesVariableBuilderFactory(injectionExpressionBuilder, this.typedExpressionFactory, this.buildInvocationBuilder());
        ProvidesInjectionNodeBuilderFactory providesInjectionNodeBuilderFactory = new ProvidesInjectionNodeBuilderFactory(providesVariableBuilderFactory, this.buildInjectionPointFactory(), this.buildAnalyser());
        ProviderVariableBuilderFactory providerVariableBuilderFactory = new ProviderVariableBuilderFactory(injectionExpressionBuilder, this.typedExpressionFactory);
        ProviderInjectionNodeBuilderFactory providerInjectionNodeBuilderFactory = new ProviderInjectionNodeBuilderFactory(this.buildAnalyser(), providerVariableBuilderFactory);
        BindProcessor bindProcessor = new BindProcessor(variableASTImplementationFactory, this.validator, this.log);
        BindProviderProcessor bindProviderProcessor = new BindProviderProcessor(providerInjectionNodeBuilderFactory);
        BindingConfigurationFactory bindingConfigurationFactory = new BindingConfigurationFactory();
        ProvidesProcessor providesProcessor = new ProvidesProcessor(providesInjectionNodeBuilderFactory, new QualifierPredicate(this.astClassFactory), new ScopePredicate(this.astClassFactory), new JavaAnnotationPredicate(), this.astClassFactory, this.buildGeneratedProviderInjectionNodeBuilder(), this.validator);
        ScopeReferenceInjectionFactory scopeInjectionFactory = new ScopeReferenceInjectionFactory(this.typedExpressionFactory, this.generationUtil, this.buildAnalyser());
        CustomScopeAspectFactoryFactory scopeAspectFactoryFactory = new CustomScopeAspectFactoryFactory(this.buildVariableFactoryBuilderFactory());
        DefineScopeProcessor defineScopeProcessor = new DefineScopeProcessor(this.astClassFactory, scopeInjectionFactory, scopeAspectFactoryFactory);
        InstallProcessor installProcessor = new InstallProcessor((ModuleRepository)this.moduleRepository);
        return new ModuleProcessor(bindProcessor, bindProviderProcessor, bindingConfigurationFactory, providesProcessor, this.astClassFactory, defineScopeProcessor, installProcessor, (ModuleRepository)this.moduleRepository, this.buildInjectionNodeRepositoryProvider());
    }

    public FactoryGenerator buildFactoryGenerator() {
        return new FactoryGenerator(this.buildInjectionGenerator(), this.instantiationStrategyFactory, new AnalysisContextFactory(), this.buildInjectionNodeRepositoryProvider(), (ModuleRepository)this.moduleRepository, new InjectionNodeImplFactory(this.buildInjectionPointFactory(), this.buildVariableFactoryBuilderFactory(), new QualifierPredicate(this.astClassFactory)), new MirroredMethodGeneratorFactory(this.variableNamer, this.generationUtil), this.generationUtil, this.variableNamer, this.validator);
    }

    public FactoriesGenerator buildFactoriesGenerator() {
        return new FactoriesGenerator(this.generationUtil, this.classNamer, this.variableNamer);
    }

    public VirtualProxyGenerator buildVirtualProxyGenerator() {
        return new VirtualProxyGenerator(this.codeModel, this.variableNamer, this.astClassFactory, this.generationUtil, this.virtualProxyCache);
    }

    public void registerFactories(Collection<? extends ASTType> factories) {
        InjectionNodeBuilderRepository repository = new InjectionNodeBuilderRepository(this.buildAnalysisRepository(), this.astClassFactory);
        for (ASTType aSTType : factories) {
            repository.putType(aSTType, (InjectionNodeBuilder)new FactoryNodeBuilder(aSTType, this.buildVariableFactoryBuilderFactory(), this.buildAnalyser()));
        }
        this.moduleRepository.addModuleRepository(repository);
    }

    private VariableFactoryBuilderFactory2 buildVariableFactoryBuilderFactory() {
        return new VariableFactoryBuilderFactory2(this.typedExpressionFactory, this.generationUtil, this.buildAnalyser(), this.buildProviderGenerator(), this.variableNamer);
    }

    public ModuleRepository getModuleRepository() {
        return this.moduleRepository;
    }

    private final class InstantiationStrategyFactoryImpl
    implements InstantiationStrategyFactory {
        private InstantiationStrategyFactoryImpl() {
        }

        public FieldInstantiationStrategy buildFieldStrategy(JDefinedClass definedClass, JBlock constructorBlock, JExpression scopes) {
            return new FieldInstantiationStrategy(definedClass, constructorBlock, scopes, CoreFactory.this.variableNamer);
        }

        public MethodInstantiationStrategy buildMethodStrategy(JBlock block, JExpression scopes) {
            return new MethodInstantiationStrategy(block, scopes, CoreFactory.this.variableNamer);
        }
    }

    private final class ModuleRepositoryImpl
    implements ModuleRepository {
        private final Set<ASTType> installedComponents = new HashSet<ASTType>();
        private final InjectionNodeBuilderRepository moduleInjectionNodeBuilderRepository = new InjectionNodeBuilderRepository(CoreFactory.access$1700(CoreFactory.this), CoreFactory.access$1000(CoreFactory.this));

        private ModuleRepositoryImpl() {
        }

        public InjectionNodeBuilderRepository buildModuleConfiguration() {
            InjectionNodeBuilderRepository repository = new InjectionNodeBuilderRepository(CoreFactory.this.buildAnalysisRepository(), CoreFactory.this.astClassFactory);
            repository.addRepository(this.moduleInjectionNodeBuilderRepository);
            return repository;
        }

        public Collection<ASTType> getInstalledAnnotatedWith(Class<? extends Annotation> annotation) {
            ImmutableSet.Builder installedBuilder = ImmutableSet.builder();
            for (ASTType installedComponent : this.installedComponents) {
                if (!installedComponent.isAnnotated(annotation)) continue;
                installedBuilder.add((Object)installedComponent);
            }
            return installedBuilder.build();
        }

        public void addInstalledComponents(ASTType[] astType) {
            this.installedComponents.addAll(Arrays.asList(astType));
        }

        public void addModuleRepository(InjectionNodeBuilderRepository repository) {
            this.moduleInjectionNodeBuilderRepository.addRepository(repository);
        }
    }

    private final class ConcreteVariableExpressionBuilderFactory
    implements VariableExpressionBuilderFactory {
        private ConcreteVariableExpressionBuilderFactory() {
        }

        public CachedExpressionDecorator buildCachedExpressionDecorator(VariableExpressionBuilder decorator) {
            return new CachedExpressionDecorator(decorator);
        }

        public ScopedExpressionDecorator buildScopedExpressionDecorator(VariableExpressionBuilder decorator) {
            return new ScopedExpressionDecorator(decorator);
        }

        public VariableBuilderExpressionDecorator buildVariableBuilderExpressionDecorator() {
            return new VariableBuilderExpressionDecorator();
        }

        public VirtualProxyExpressionDecorator buildVirtualProxyExpressionDecorator(VariableExpressionBuilder decorator) {
            ProxyVariableBuilder proxyVariableBuilder = new ProxyVariableBuilder(CoreFactory.this.variableNamer);
            VirtualProxyGenerator virtualProxyGenerator = new VirtualProxyGenerator(CoreFactory.this.codeModel, CoreFactory.this.variableNamer, CoreFactory.this.astClassFactory, CoreFactory.this.generationUtil, CoreFactory.this.virtualProxyCache);
            return new VirtualProxyExpressionDecorator(decorator, proxyVariableBuilder, virtualProxyGenerator, CoreFactory.this.typedExpressionFactory);
        }
    }

    private static final class ASTElementFactoryVProxy
    implements Provider<ASTElementFactory> {
        private Provider<ASTElementFactory> delegate;

        private ASTElementFactoryVProxy() {
        }

        public ASTElementFactory get() {
            if (this.delegate == null) {
                throw new VirtualProxyException("Trying to use a proxied instance before initialization");
            }
            return (ASTElementFactory)this.delegate.get();
        }

        private void load(Provider<ASTElementFactory> delegate) {
            this.delegate = delegate;
        }
    }

    private final class ConcreteASTFactory
    implements ASTFactory {
        private ElementConverterFactory elementConverterFactory;
        private Provider<ASTElementFactory> astElementFactoryProvider;

        private ConcreteASTFactory() {
        }

        public void setElementConverterFactory(ElementConverterFactory elementConverterFactory) {
            this.elementConverterFactory = elementConverterFactory;
        }

        public void setAstElementFactoryProvider(Provider<ASTElementFactory> astElementFactoryProvider) {
            this.astElementFactoryProvider = astElementFactoryProvider;
        }

        public ASTElementAnnotation buildASTElementAnnotation(AnnotationMirror annotationMirror, ASTType type) {
            return new ASTElementAnnotation(annotationMirror, type, this.elementConverterFactory);
        }

        public LazyParametrizedTypeParameterBuilder buildParameterBuilder(ParameterizedType genericType) {
            return new LazyParametrizedTypeParameterBuilder(genericType, CoreFactory.this.astClassFactory);
        }

        public LazyClassParameterBuilder buildParameterBuilder(Class type) {
            return new LazyClassParameterBuilder(type, CoreFactory.this.astClassFactory);
        }

        public LazyASTTypeParameterBuilder buildParameterBuilder(ASTType type) {
            return new LazyASTTypeParameterBuilder(type);
        }

        public LazyElementParameterBuilder buildParameterBuilder(DeclaredType declaredType) {
            ASTTypeBuilderVisitor astTypeBuilderVisitor = new ASTTypeBuilderVisitor(this.astElementFactoryProvider);
            return new LazyElementParameterBuilder(declaredType, astTypeBuilderVisitor);
        }

        public ASTGenericTypeWrapper buildGenericTypeWrapper(ASTType astType, LazyTypeParameterBuilder lazyTypeParameterBuilder) {
            return new ASTGenericTypeWrapper(astType, lazyTypeParameterBuilder);
        }
    }

    private static class InjectionBuilderContextFactoryImpl
    implements InjectionBuilderContextFactory {
        private InjectionBuilderContextFactoryImpl() {
        }

        public InjectionBuilderContext buildContext(JBlock block, InstantiationStrategy instantiateOnceStrategy, JDefinedClass definedClass, JExpression scopeVar, Map<InjectionNode, TypedExpression> expressionMap) {
            return new InjectionBuilderContext(block, definedClass, scopeVar, expressionMap, instantiateOnceStrategy);
        }
    }

    private final class GeneratedProviderInjectionNodeBuilderProvider
    implements Provider<GeneratedProviderInjectionNodeBuilder> {
        private GeneratedProviderInjectionNodeBuilderProvider() {
        }

        public GeneratedProviderInjectionNodeBuilder get() {
            return CoreFactory.this.buildGeneratedProviderInjectionNodeBuilder();
        }
    }
}

