/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTConstructor;
import org.androidtransfuse.adapter.ASTField;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.ASTUtils;
import org.androidtransfuse.adapter.PackageClass;

public enum ASTPrimitiveType implements ASTType
{
    BOOLEAN("boolean", Boolean.class),
    BYTE("byte", Byte.class),
    SHORT("short", Short.class),
    CHAR("char", Character.class),
    INT("int", Integer.class),
    FLOAT("float", Float.class),
    LONG("long", Long.class),
    DOUBLE("double", Double.class);

    private static final ImmutableMap<String, ASTPrimitiveType> AUTOBOX_TYPE_MAP;
    private final Class clazz;
    private final String label;

    private ASTPrimitiveType(String label, Class clazz) {
        this.label = label;
        this.clazz = clazz;
    }

    @Override
    public boolean isAnnotated(Class<? extends Annotation> annotation) {
        return false;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotation) {
        return null;
    }

    @Override
    public ImmutableSet<ASTMethod> getMethods() {
        return ImmutableSet.of();
    }

    @Override
    public ImmutableSet<ASTField> getFields() {
        return ImmutableSet.of();
    }

    @Override
    public ImmutableSet<ASTConstructor> getConstructors() {
        return ImmutableSet.of();
    }

    @Override
    public String getName() {
        return this.label;
    }

    public Class getObjectClass() {
        return this.clazz;
    }

    @Override
    public boolean isConcreteClass() {
        return false;
    }

    @Override
    public ImmutableSet<ASTAnnotation> getAnnotations() {
        return ImmutableSet.of();
    }

    @Override
    public ImmutableSet<ASTType> getInterfaces() {
        return ImmutableSet.of();
    }

    @Override
    public ASTType getSuperClass() {
        return null;
    }

    @Override
    public ImmutableList<ASTType> getGenericParameters() {
        return ImmutableList.of();
    }

    public static ASTPrimitiveType getAutoboxType(String name) {
        return (ASTPrimitiveType)AUTOBOX_TYPE_MAP.get((Object)name);
    }

    @Override
    public boolean inheritsFrom(ASTType type) {
        return type == this;
    }

    @Override
    public boolean extendsFrom(ASTType type) {
        return type == this;
    }

    @Override
    public boolean implementsFrom(ASTType type) {
        return type == this;
    }

    @Override
    public PackageClass getPackageClass() {
        return new PackageClass(null, this.label);
    }

    @Override
    public ASTAnnotation getASTAnnotation(Class<? extends Annotation> annotation) {
        return ASTUtils.getInstance().getAnnotation(annotation, this.getAnnotations());
    }

    public String toString() {
        return this.getName();
    }

    static {
        ImmutableMap.Builder autoboxTypeMapBuilder = ImmutableMap.builder();
        for (ASTPrimitiveType astPrimitive : ASTPrimitiveType.values()) {
            autoboxTypeMapBuilder.put((Object)astPrimitive.getObjectClass().getName(), (Object)astPrimitive);
        }
        AUTOBOX_TYPE_MAP = autoboxTypeMapBuilder.build();
    }
}

