/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter;

import com.google.common.collect.ImmutableSet;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTType;

public final class ASTUtils {
    private static final ASTUtils INSTANCE = new ASTUtils();

    private ASTUtils() {
    }

    public static ASTUtils getInstance() {
        return INSTANCE;
    }

    public boolean inherits(ASTType astType, ASTType inheritable, boolean implement, boolean extend) {
        if (astType == null) {
            return false;
        }
        if (astType.equals(inheritable)) {
            return true;
        }
        if (implement) {
            for (ASTType typeInterfaces : astType.getInterfaces()) {
                if (!this.inherits(typeInterfaces, inheritable, implement, extend)) continue;
                return true;
            }
        }
        return extend && this.inherits(astType.getSuperClass(), inheritable, implement, extend);
    }

    public ASTAnnotation getAnnotation(Class resourceClass, ImmutableSet<ASTAnnotation> annotations) {
        for (ASTAnnotation astAnnotation : annotations) {
            if (!astAnnotation.getASTType().getName().equals(resourceClass.getCanonicalName())) continue;
            return astAnnotation;
        }
        return null;
    }
}

