/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter;

import java.util.ArrayList;
import java.util.List;
import org.androidtransfuse.adapter.ASTArrayType;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTParameter;
import org.androidtransfuse.adapter.ASTPrimitiveType;
import org.androidtransfuse.adapter.ASTType;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class MethodSignature {
    private final String methodSignature;

    public MethodSignature(ASTMethod method) {
        this.methodSignature = this.makeDescriptor(method);
    }

    public MethodSignature(ASTType returnType, String methodName, List<ASTType> paramTypes) {
        this.methodSignature = this.makeDescriptor(returnType, methodName, paramTypes);
    }

    private String makeDescriptor(ASTMethod method) {
        ArrayList<ASTType> paramTypes = new ArrayList<ASTType>();
        for (ASTParameter parameter : method.getParameters()) {
            paramTypes.add(parameter.getASTType());
        }
        return this.makeDescriptor(method.getReturnType(), method.getName(), paramTypes);
    }

    private String makeDescriptor(ASTType returnType, String methodName, List<ASTType> params) {
        return methodName + ':' + this.makeDescriptor(params, returnType);
    }

    private String makeDescriptor(List<ASTType> paramTypes, ASTType retType) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (ASTType paramType : paramTypes) {
            this.makeTypeDescriptor(builder, paramType);
        }
        builder.append(')');
        this.makeTypeDescriptor(builder, retType);
        return builder.toString();
    }

    private void makeTypeDescriptor(StringBuilder builder, ASTType type) {
        if (type instanceof ASTArrayType) {
            builder.append('[');
        }
        this.makeTypeDesc(builder, type);
    }

    private void makeTypeDesc(StringBuilder builder, ASTType type) {
        if (type instanceof ASTPrimitiveType) {
            builder.append(type.getName());
        } else {
            builder.append('L').append(type.getName().replace('.', '/')).append(';');
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodSignature)) {
            return false;
        }
        MethodSignature that = (MethodSignature)o;
        return new EqualsBuilder().append((Object)this.methodSignature, (Object)that.methodSignature).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.methodSignature).hashCode();
    }
}

