/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter.classes;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.androidtransfuse.TransfuseAdapterException;
import org.androidtransfuse.adapter.ASTAccessModifier;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTField;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.ASTUtils;
import org.androidtransfuse.util.AccessibleElementPrivilegedAction;

public class ASTClassField
implements ASTField {
    private final Field field;
    private final ASTType astType;
    private final ASTAccessModifier modifier;
    private final ImmutableSet<ASTAnnotation> annotations;

    public ASTClassField(Field field, ASTType astType, ASTAccessModifier modifier, ImmutableSet<ASTAnnotation> annotations) {
        this.field = field;
        this.astType = astType;
        this.modifier = modifier;
        this.annotations = annotations;
    }

    @Override
    public ASTType getASTType() {
        return this.astType;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public boolean isAnnotated(Class<? extends Annotation> annotation) {
        return this.field.isAnnotationPresent(annotation);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotation) {
        return this.field.getAnnotation(annotation);
    }

    @Override
    public ImmutableSet<ASTAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public ASTAccessModifier getAccessModifier() {
        return this.modifier;
    }

    @Override
    public ASTAnnotation getASTAnnotation(Class<? extends Annotation> annotation) {
        return ASTUtils.getInstance().getAnnotation(annotation, this.getAnnotations());
    }

    @Override
    public Object getConstantValue() {
        try {
            return AccessController.doPrivileged(new PrivateConstantFieldAccessPrivilegedAction(this.field));
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (PrivilegedActionException e) {
            throw new TransfuseAdapterException("PrivilegedActionException when trying to set field: " + this.field, e);
        }
    }

    private static final class PrivateConstantFieldAccessPrivilegedAction
    extends AccessibleElementPrivilegedAction<Object, Field> {
        protected PrivateConstantFieldAccessPrivilegedAction(Field accessibleObject) {
            super((AccessibleObject)accessibleObject);
        }

        public Object run(Field classField) throws IllegalAccessException {
            return classField.get(null);
        }
    }
}

