/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter.classes;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import javax.inject.Inject;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.ASTWildcardType;
import org.androidtransfuse.adapter.LazyTypeParameterBuilder;
import org.androidtransfuse.adapter.classes.ASTClassFactory;

public class LazyClassParameterBuilder
implements LazyTypeParameterBuilder,
Function<Type, ASTType> {
    private final ParameterizedType parameterizedType;
    private final ASTClassFactory astClassFactory;
    private ImmutableList<ASTType> genericParameters = null;

    @Inject
    public LazyClassParameterBuilder(ParameterizedType parameterizedType, ASTClassFactory astClassFactory) {
        this.parameterizedType = parameterizedType;
        this.astClassFactory = astClassFactory;
    }

    @Override
    public synchronized ImmutableList<ASTType> buildGenericParameters() {
        if (this.genericParameters == null) {
            this.genericParameters = this.innerBuildGenericParameters();
        }
        return this.genericParameters;
    }

    private ImmutableList<ASTType> innerBuildGenericParameters() {
        return FluentIterable.from(Arrays.asList(this.parameterizedType.getActualTypeArguments())).transform((Function)this).toList();
    }

    public ASTType apply(Type input) {
        return this.getClass(input);
    }

    private ASTType getClass(Type type) {
        if (type instanceof Class) {
            return this.astClassFactory.getType((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return this.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return this.getClass(((GenericArrayType)type).getGenericComponentType());
        }
        if (type instanceof TypeVariable) {
            return this.getClass(((TypeVariable)type).getBounds()[0]);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            ASTType extendsBound = null;
            ASTType superBound = null;
            if (wildcardType.getUpperBounds().length > 0) {
                superBound = this.getClass(wildcardType.getUpperBounds()[0]);
            }
            if (wildcardType.getLowerBounds().length > 0) {
                extendsBound = this.getClass(wildcardType.getLowerBounds()[0]);
            }
            return new ASTWildcardType(superBound, extendsBound);
        }
        return null;
    }
}

