/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter.element;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.element.ElementConverterFactory;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ASTElementAnnotation
implements ASTAnnotation {
    private final AnnotationMirror annotationMirror;
    private final ASTType type;
    private final ElementConverterFactory elementConverterFactory;

    @Inject
    public ASTElementAnnotation(AnnotationMirror annotationMirror, ASTType type, ElementConverterFactory elementConverterFactory) {
        this.annotationMirror = annotationMirror;
        this.elementConverterFactory = elementConverterFactory;
        this.type = type;
    }

    @Override
    public ImmutableSet<String> getPropertyNames() {
        return FluentIterable.from(this.annotationMirror.getElementValues().keySet()).transform((Function)new ExtractElementName()).toSet();
    }

    public AnnotationMirror getAnnotationMirror() {
        return this.annotationMirror;
    }

    @Override
    public <T> T getProperty(String value, Class<T> type) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : this.annotationMirror.getElementValues().entrySet()) {
            if (!value.equals(entry.getKey().getSimpleName().toString())) continue;
            return (T)entry.getValue().accept(this.elementConverterFactory.buildAnnotationValueConverter(type), null);
        }
        return null;
    }

    @Override
    public ASTType getASTType() {
        return this.type;
    }

    public String toString() {
        return "ASTElementAnnotation{type=" + this.type + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ASTAnnotation)) {
            return false;
        }
        ASTAnnotation that = (ASTAnnotation)o;
        if (!this.type.equals(that.getASTType())) {
            return false;
        }
        HashMap<String, Object> thisProperties = new HashMap<String, Object>();
        HashMap<String, Object> thatProperties = new HashMap<String, Object>();
        for (String property : this.getPropertyNames()) {
            thisProperties.put(property, this.getProperty(property, Object.class));
            thatProperties.put(property, that.getProperty(property, Object.class));
        }
        return ((Object)thisProperties).equals(thatProperties);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.type).hashCode();
    }

    private static final class ExtractElementName
    implements Function<ExecutableElement, String> {
        private ExtractElementName() {
        }

        public String apply(ExecutableElement property) {
            return property.getSimpleName().toString();
        }
    }
}

