/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter.element;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.androidtransfuse.adapter.ASTAccessModifier;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTParameter;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.element.ASTElementBase;
import org.androidtransfuse.adapter.element.ASTTypeBuilderVisitor;
import org.androidtransfuse.adapter.element.ASTTypeLazyLoader;

public class ASTElementMethod
extends ASTElementBase
implements ASTMethod {
    private final ASTTypeLazyLoader<ExecutableElement> astTypeLoader;
    private final ImmutableList<ASTParameter> parameters;
    private final ASTAccessModifier modifier;
    private final ImmutableSet<ASTType> throwsTypes;

    public ASTElementMethod(ExecutableElement executableElement, ASTTypeBuilderVisitor astTypeBuilderVisitor, ImmutableList<ASTParameter> parameters, ASTAccessModifier modifier, ImmutableSet<ASTAnnotation> annotations, ImmutableSet<ASTType> throwsTypes) {
        super(executableElement, annotations);
        this.modifier = modifier;
        this.throwsTypes = throwsTypes;
        this.astTypeLoader = new ASTMethodTypeLazyLoader(executableElement, astTypeBuilderVisitor);
        this.parameters = parameters;
    }

    @Override
    public List<ASTParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public ASTType getReturnType() {
        return this.astTypeLoader.getASTType();
    }

    @Override
    public ASTAccessModifier getAccessModifier() {
        return this.modifier;
    }

    @Override
    public ImmutableSet<ASTType> getThrowsTypes() {
        return this.throwsTypes;
    }

    private static final class ASTMethodTypeLazyLoader
    extends ASTTypeLazyLoader<ExecutableElement> {
        public ASTMethodTypeLazyLoader(ExecutableElement element, ASTTypeBuilderVisitor astTypeBuilderVisitor) {
            super(element, astTypeBuilderVisitor);
        }

        @Override
        protected ASTType buildASTType(ExecutableElement element, ASTTypeBuilderVisitor astTypeBuilderVisitor) {
            return element.getReturnType().accept(astTypeBuilderVisitor, null);
        }
    }
}

