/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter.element;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import javax.lang.model.element.TypeElement;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTConstructor;
import org.androidtransfuse.adapter.ASTField;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.ASTUtils;
import org.androidtransfuse.adapter.PackageClass;
import org.androidtransfuse.adapter.element.ASTElementBase;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ASTElementType
extends ASTElementBase
implements ASTType {
    private final TypeElement typeElement;
    private final PackageClass packageClass;
    private final ImmutableSet<ASTMethod> methods;
    private final ImmutableSet<ASTConstructor> constructors;
    private final ImmutableSet<ASTField> fields;
    private final ImmutableSet<ASTType> interfaces;
    private final ASTType superClass;

    public ASTElementType(PackageClass packageClass, TypeElement typeElement, ImmutableSet<ASTConstructor> constructors, ImmutableSet<ASTMethod> methods, ImmutableSet<ASTField> fields, ASTType superClass, ImmutableSet<ASTType> interfaces, ImmutableSet<ASTAnnotation> annotations) {
        super(typeElement, annotations);
        this.packageClass = packageClass;
        this.typeElement = typeElement;
        this.constructors = constructors;
        this.methods = methods;
        this.fields = fields;
        this.superClass = superClass;
        this.interfaces = interfaces;
    }

    @Override
    public String getName() {
        return this.packageClass.getCanonicalName();
    }

    @Override
    public PackageClass getPackageClass() {
        return this.packageClass;
    }

    @Override
    public ImmutableSet<ASTMethod> getMethods() {
        return this.methods;
    }

    @Override
    public ImmutableSet<ASTField> getFields() {
        return this.fields;
    }

    @Override
    public ImmutableSet<ASTConstructor> getConstructors() {
        return this.constructors;
    }

    @Override
    public boolean isConcreteClass() {
        return this.typeElement.getKind().isClass();
    }

    @Override
    public ASTType getSuperClass() {
        return this.superClass;
    }

    @Override
    public ImmutableSet<ASTType> getInterfaces() {
        return this.interfaces;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ASTType)) {
            return false;
        }
        ASTType that = (ASTType)o;
        return new EqualsBuilder().append((Object)this.getName(), (Object)that.getName()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getName()).hashCode();
    }

    @Override
    public ImmutableList<ASTType> getGenericParameters() {
        return ImmutableList.of();
    }

    @Override
    public boolean inheritsFrom(ASTType type) {
        return ASTUtils.getInstance().inherits(this, type, true, true);
    }

    @Override
    public boolean extendsFrom(ASTType type) {
        return ASTUtils.getInstance().inherits(this, type, false, true);
    }

    @Override
    public boolean implementsFrom(ASTType type) {
        return ASTUtils.getInstance().inherits(this, type, true, false);
    }

    @Override
    public ASTAnnotation getASTAnnotation(Class<? extends Annotation> annotation) {
        return ASTUtils.getInstance().getAnnotation(annotation, this.getAnnotations());
    }

    public String toString() {
        return this.getName();
    }
}

