/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter.element;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import javax.inject.Inject;
import javax.lang.model.type.DeclaredType;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.LazyTypeParameterBuilder;
import org.androidtransfuse.adapter.element.ASTTypeBuilderVisitor;

public class LazyElementParameterBuilder
implements LazyTypeParameterBuilder {
    private final DeclaredType declaredType;
    private final ASTTypeBuilderVisitor astTypeBuilderVisitor;
    private ImmutableList<ASTType> genericParameters = null;

    @Inject
    public LazyElementParameterBuilder(DeclaredType declaredType, ASTTypeBuilderVisitor astTypeBuilderVisitor) {
        this.declaredType = declaredType;
        this.astTypeBuilderVisitor = astTypeBuilderVisitor;
    }

    @Override
    public synchronized ImmutableList<ASTType> buildGenericParameters() {
        if (this.genericParameters == null) {
            this.genericParameters = this.innerBuildGenericParameters();
        }
        return this.genericParameters;
    }

    public ImmutableList<ASTType> innerBuildGenericParameters() {
        return FluentIterable.from(this.declaredType.getTypeArguments()).transform((Function)this.astTypeBuilderVisitor).toList();
    }
}

