/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter.element;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.element.ASTElementFactory;

public class ReloadableASTElementFactory
implements Function<Element, Provider<ASTType>> {
    private final ASTElementFactory astElementFactory;
    private final Elements elements;

    @Inject
    public ReloadableASTElementFactory(ASTElementFactory astElementFactory, Elements elements) {
        this.astElementFactory = astElementFactory;
        this.elements = elements;
    }

    public Collection<Provider<ASTType>> buildProviders(Collection<? extends Element> elementCollection) {
        return Collections2.transform(elementCollection, (Function)this);
    }

    public Provider<ASTType> apply(Element input) {
        return new ReloadableASTTypeProvider(((Object)input.asType()).toString());
    }

    private final class ReloadableASTTypeProvider
    implements Provider<ASTType> {
        private String elementName;

        private ReloadableASTTypeProvider(String elementName) {
            this.elementName = elementName;
        }

        public ASTType get() {
            TypeElement typeElement = ReloadableASTElementFactory.this.elements.getTypeElement(this.elementName);
            return ReloadableASTElementFactory.this.astElementFactory.getType(typeElement);
        }

        public String toString() {
            return this.elementName;
        }
    }
}

