/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.config;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Provider;
import org.androidtransfuse.config.EnterableScope;
import org.androidtransfuse.config.OutOfScopeException;
import org.androidtransfuse.scope.ScopeKey;

public class MapScope
implements EnterableScope {
    private ConcurrentMap<ScopeKey<?>, Object> values;

    @Override
    public void enter() {
        this.values = new ConcurrentHashMap();
    }

    @Override
    public void exit() {
        this.values = null;
    }

    @Override
    public <T> void seed(ScopeKey<T> key, T value) {
        ConcurrentMap<ScopeKey<?>, Object> scopedObjects = this.getScopedObjectMap(key);
        scopedObjects.put(key, value);
    }

    public <T> T getScopedObject(ScopeKey<T> key, Provider<T> provider) {
        Object value;
        ConcurrentMap<ScopeKey<?>, Object> scopedObjects = this.getScopedObjectMap(key);
        Object current = scopedObjects.get(key);
        if (current == null && (current = scopedObjects.putIfAbsent(key, value = provider.get())) == null) {
            current = value;
        }
        return (T)current;
    }

    private <T> ConcurrentMap<ScopeKey<?>, Object> getScopedObjectMap(ScopeKey<T> key) {
        if (this.values == null) {
            throw new OutOfScopeException("Cannot access " + key + " outside of a scoping block");
        }
        return this.values;
    }
}

