/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.config;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Provider;
import org.androidtransfuse.config.EnterableScope;
import org.androidtransfuse.config.OutOfScopeException;
import org.androidtransfuse.scope.ScopeKey;

public class ThreadLocalScope
implements EnterableScope {
    private final ThreadLocal<Map<ScopeKey<?>, Object>> values = new ThreadLocal();

    @Override
    public void enter() {
        this.values.set(new HashMap());
    }

    @Override
    public void exit() {
        this.values.remove();
    }

    @Override
    public <T> void seed(ScopeKey<T> key, T value) {
        Map<ScopeKey<?>, Object> scopedObjects = this.getScopedObjectMap(key);
        scopedObjects.put(key, value);
    }

    public <T> T getScopedObject(ScopeKey<T> key, Provider<T> unscoped) {
        Map<ScopeKey<?>, Object> scopedObjects = this.getScopedObjectMap(key);
        Object current = scopedObjects.get(key);
        if (current == null && !scopedObjects.containsKey(key)) {
            current = unscoped.get();
            scopedObjects.put(key, current);
        }
        return (T)current;
    }

    private <T> Map<ScopeKey<?>, Object> getScopedObjectMap(ScopeKey<T> key) {
        Map<ScopeKey<?>, Object> scopedObjects = this.values.get();
        if (scopedObjects == null) {
            throw new OutOfScopeException("Cannot access " + key + " outside of a scoping block");
        }
        return scopedObjects;
    }
}

