/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.transaction;

import javax.inject.Provider;
import org.androidtransfuse.config.EnterableScope;
import org.androidtransfuse.transaction.TransactionRuntimeException;
import org.androidtransfuse.transaction.TransactionWorker;

public class ScopedTransactionWorker<V, R>
implements TransactionWorker<V, R> {
    private final EnterableScope simpleScope;
    private final Provider<? extends TransactionWorker<V, R>> workerProvider;
    private TransactionWorker<V, R> scoped = null;
    private boolean complete = false;
    private Exception error;

    public ScopedTransactionWorker(EnterableScope simpleScope, Provider<? extends TransactionWorker<V, R>> workerProvider) {
        this.simpleScope = simpleScope;
        this.workerProvider = workerProvider;
    }

    @Override
    public boolean isComplete() {
        return this.complete && this.scoped != null && this.scoped.isComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R run(V value) {
        try {
            this.simpleScope.enter();
            this.scoped = (TransactionWorker)this.workerProvider.get();
            R result = this.scoped.run(value);
            this.complete = true;
            R r = result;
            return r;
        }
        catch (TransactionRuntimeException re) {
            this.error = re;
            this.complete = false;
        }
        finally {
            this.simpleScope.exit();
        }
        return null;
    }

    @Override
    public Exception getError() {
        return this.error;
    }
}

