/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.transaction;

import org.androidtransfuse.transaction.TransactionWorker;

public class Transaction<V, R>
implements Runnable {
    private final TransactionWorker<V, R> worker;
    private final V value;
    private R result = null;
    private boolean complete = false;

    public Transaction(TransactionWorker<V, R> worker) {
        this(null, worker);
    }

    public Transaction(V value, TransactionWorker<V, R> worker) {
        this.value = value;
        this.worker = worker;
    }

    public boolean isComplete() {
        return this.complete && this.worker != null && this.worker.isComplete();
    }

    public V getValue() {
        return this.value;
    }

    public R getResult() {
        return this.result;
    }

    public Exception getError() {
        return this.worker == null ? null : this.worker.getError();
    }

    @Override
    public void run() {
        this.result = this.worker.run(this.value);
        this.complete = true;
    }
}

