/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.transaction;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import org.androidtransfuse.transaction.TransactionProcessor;

public class TransactionProcessorChain
implements TransactionProcessor<Void, Void> {
    private final TransactionProcessor beforeProcessor;
    private final TransactionProcessor afterProcessor;

    public TransactionProcessorChain(TransactionProcessor beforeProcessor, TransactionProcessor afterProcessor) {
        this.beforeProcessor = beforeProcessor;
        this.afterProcessor = afterProcessor;
    }

    @Override
    public void execute() {
        this.beforeProcessor.execute();
        if (this.beforeProcessor.isComplete() && !this.afterProcessor.isComplete()) {
            this.afterProcessor.execute();
        }
    }

    @Override
    public boolean isComplete() {
        return this.beforeProcessor.isComplete() && this.afterProcessor.isComplete();
    }

    @Override
    public ImmutableSet<Exception> getErrors() {
        ImmutableSet.Builder exceptions = ImmutableSet.builder();
        exceptions.addAll(this.beforeProcessor.getErrors());
        exceptions.addAll(this.afterProcessor.getErrors());
        return exceptions.build();
    }

    @Override
    public Map<Void, Void> getResults() {
        return new HashMap<Void, Void>();
    }
}

