/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.transaction;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.androidtransfuse.transaction.Transaction;
import org.androidtransfuse.transaction.TransactionFactory;
import org.androidtransfuse.transaction.TransactionProcessor;
import org.androidtransfuse.transaction.TransactionProcessorPool;

public class TransactionProcessorChannel<V, R, R2>
implements TransactionProcessor<Map<V, R>, R2> {
    private TransactionProcessor<V, R> completionProcessor;
    private TransactionProcessorPool<Map<V, R>, R2> afterCompletionProcessor;
    private TransactionFactory<Map<V, R>, R2> completionTransactionFactory;

    public TransactionProcessorChannel(TransactionProcessor<V, R> completionProcessor, TransactionProcessorPool<Map<V, R>, R2> afterCompletionProcessor, TransactionFactory<Map<V, R>, R2> completionTransactionFactory) {
        this.completionProcessor = completionProcessor;
        this.afterCompletionProcessor = afterCompletionProcessor;
        this.completionTransactionFactory = completionTransactionFactory;
    }

    @Override
    public void execute() {
        boolean workToComplete = !this.completionProcessor.isComplete();
        this.completionProcessor.execute();
        if (workToComplete && this.completionProcessor.isComplete()) {
            Transaction<Map<V, R>, R2> completionTransaction = this.completionTransactionFactory.buildTransaction(this.completionProcessor.getResults());
            this.afterCompletionProcessor.submit(completionTransaction);
            this.afterCompletionProcessor.execute();
        }
    }

    @Override
    public boolean isComplete() {
        return this.completionProcessor.isComplete() && this.afterCompletionProcessor.isComplete();
    }

    @Override
    public ImmutableSet<Exception> getErrors() {
        ImmutableSet.Builder exceptions = ImmutableSet.builder();
        exceptions.addAll(this.completionProcessor.getErrors());
        exceptions.addAll(this.afterCompletionProcessor.getErrors());
        return exceptions.build();
    }

    @Override
    public Map<Map<V, R>, R2> getResults() {
        return this.afterCompletionProcessor.getResults();
    }
}

