/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.transaction;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import org.androidtransfuse.transaction.TransactionProcessor;

public class TransactionProcessorComposite<V, R>
implements TransactionProcessor<V, R> {
    private final ImmutableSet<TransactionProcessor<V, R>> processors;

    public TransactionProcessorComposite(ImmutableSet<TransactionProcessor<V, R>> processors) {
        this.processors = processors;
    }

    @Override
    public void execute() {
        for (TransactionProcessor processor : this.processors) {
            processor.execute();
        }
    }

    @Override
    public boolean isComplete() {
        for (TransactionProcessor processor : this.processors) {
            if (processor.isComplete()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ImmutableSet<Exception> getErrors() {
        ImmutableSet.Builder exceptions = ImmutableSet.builder();
        for (TransactionProcessor processor : this.processors) {
            exceptions.addAll(processor.getErrors());
        }
        return exceptions.build();
    }

    @Override
    public Map<V, R> getResults() {
        HashMap results = new HashMap();
        for (TransactionProcessor processor : this.processors) {
            results.putAll(processor.getResults());
        }
        return results;
    }
}

