/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.validation;

import java.util.Map;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.tools.Diagnostic;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTBase;
import org.androidtransfuse.adapter.element.ASTElementAnnotation;
import org.androidtransfuse.adapter.element.ASTElementField;
import org.androidtransfuse.adapter.element.ASTElementMethod;
import org.androidtransfuse.adapter.element.ASTElementType;

public class Validator {
    private final Messager messager;

    @Inject
    public Validator(Messager messager) {
        this.messager = messager;
    }

    public ValidationBuilder error(String message) {
        return new ValidationBuilder(Diagnostic.Kind.ERROR, message);
    }

    public final class ValidationBuilder {
        private Diagnostic.Kind kind;
        private String message;
        private Element element;
        private AnnotationMirror annotation;
        private AnnotationValue value;

        private ValidationBuilder(Diagnostic.Kind kind, String message) {
            this.kind = kind;
            this.message = message;
        }

        public ValidationBuilder element(ASTBase astBase) {
            if (astBase instanceof ASTElementType) {
                this.element = ((ASTElementType)astBase).getElement();
            }
            if (astBase instanceof ASTElementField) {
                this.element = ((ASTElementField)astBase).getElement();
            }
            if (astBase instanceof ASTElementMethod) {
                this.element = ((ASTElementMethod)astBase).getElement();
            }
            return this;
        }

        public ValidationBuilder annotation(ASTAnnotation annotation) {
            if (annotation instanceof ASTElementAnnotation) {
                this.annotation = ((ASTElementAnnotation)annotation).getAnnotationMirror();
            }
            return this;
        }

        public ValidationBuilder parameter(String propertyName) {
            if (this.annotation != null) {
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : this.annotation.getElementValues().entrySet()) {
                    if (!propertyName.equals(entry.getKey().getSimpleName().toString())) continue;
                    this.value = entry.getValue();
                    break;
                }
            }
            return this;
        }

        public void build() {
            if (this.element != null) {
                if (this.annotation != null) {
                    if (this.value != null) {
                        Validator.this.messager.printMessage(this.kind, this.message, this.element, this.annotation, this.value);
                    } else {
                        Validator.this.messager.printMessage(this.kind, this.message, this.element, this.annotation);
                    }
                } else {
                    Validator.this.messager.printMessage(this.kind, this.message, this.element);
                }
            } else {
                Validator.this.messager.printMessage(this.kind, this.message);
            }
        }
    }
}

