/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.lang.model.SourceVersion;
import org.androidtransfuse.SupportedAnnotations;

public abstract class AnnotationProcessorBase
extends AbstractProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        Class<? extends Annotation>[] supportedAnnotations = this.getClass().getAnnotation(SupportedAnnotations.class).value();
        return FluentIterable.from(Arrays.asList(supportedAnnotations)).transform((Function)new ClassToNameTransform()).toSet();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private static class ClassToNameTransform
    implements Function<Class, String> {
        private ClassToNameTransform() {
        }

        public String apply(Class input) {
            return input.getName();
        }
    }
}

