/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter;

import java.lang.reflect.Modifier;

public enum ASTAccessModifier {
    PUBLIC(1, 1){

        @Override
        public boolean isModifier(int modifier) {
            return Modifier.isPublic(modifier);
        }
    }
    ,
    PROTECTED(2, 4){

        @Override
        public boolean isModifier(int modifier) {
            return Modifier.isProtected(modifier);
        }
    }
    ,
    PACKAGE_PRIVATE(0, 0){

        @Override
        public boolean isModifier(int modifier) {
            return false;
        }
    }
    ,
    PRIVATE(4, 2){

        @Override
        public boolean isModifier(int modifier) {
            return Modifier.isPrivate(modifier);
        }
    };

    private final int codeModelJMod;
    private final int javaModifier;

    private ASTAccessModifier(int codeModelJMod, int javaModifier) {
        this.codeModelJMod = codeModelJMod;
        this.javaModifier = javaModifier;
    }

    public int getCodeModelJMod() {
        return this.codeModelJMod;
    }

    public int getJavaModifier() {
        return this.javaModifier;
    }

    public static ASTAccessModifier getModifier(int modifier) {
        for (ASTAccessModifier astAccessModifier : ASTAccessModifier.values()) {
            if (!astAccessModifier.isModifier(modifier)) continue;
            return astAccessModifier;
        }
        return PACKAGE_PRIVATE;
    }

    public abstract boolean isModifier(int var1);
}

