/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTConstructor;
import org.androidtransfuse.adapter.ASTField;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.LazyTypeParameterBuilder;
import org.androidtransfuse.adapter.PackageClass;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ASTGenericTypeWrapper
implements ASTType {
    private final ASTType astType;
    private final LazyTypeParameterBuilder lazyTypeParameterBuilder;

    @Inject
    public ASTGenericTypeWrapper(ASTType astType, LazyTypeParameterBuilder lazyTypeParameterBuilder) {
        this.astType = astType;
        this.lazyTypeParameterBuilder = lazyTypeParameterBuilder;
    }

    @Override
    public ImmutableList<ASTType> getGenericParameters() {
        return this.lazyTypeParameterBuilder.buildGenericParameters();
    }

    public ASTType getWrappedType() {
        return this.astType;
    }

    @Override
    public ImmutableSet<ASTMethod> getMethods() {
        return this.astType.getMethods();
    }

    @Override
    public ImmutableSet<ASTField> getFields() {
        return this.astType.getFields();
    }

    @Override
    public ImmutableSet<ASTConstructor> getConstructors() {
        return this.astType.getConstructors();
    }

    @Override
    public boolean isConcreteClass() {
        return this.astType.isConcreteClass();
    }

    @Override
    public boolean isInterface() {
        return this.astType.isInterface();
    }

    @Override
    public boolean isEnum() {
        return this.astType.isEnum();
    }

    @Override
    public boolean isFinal() {
        return this.astType.isFinal();
    }

    @Override
    public ASTType getSuperClass() {
        return this.astType.getSuperClass();
    }

    @Override
    public ImmutableSet<ASTType> getInterfaces() {
        return this.astType.getInterfaces();
    }

    @Override
    public boolean isAnnotated(Class<? extends Annotation> annotation) {
        return this.astType.isAnnotated(annotation);
    }

    @Override
    public ImmutableSet<ASTAnnotation> getAnnotations() {
        return this.astType.getAnnotations();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotation) {
        return this.astType.getAnnotation(annotation);
    }

    @Override
    public String getName() {
        return this.astType.getName();
    }

    @Override
    public boolean inheritsFrom(ASTType type) {
        return this.astType.inheritsFrom(type);
    }

    @Override
    public boolean extendsFrom(ASTType type) {
        return this.astType.extendsFrom(type);
    }

    @Override
    public boolean implementsFrom(ASTType type) {
        return this.astType.implementsFrom(type);
    }

    @Override
    public ASTAnnotation getASTAnnotation(Class<? extends Annotation> annotation) {
        return this.astType.getASTAnnotation(annotation);
    }

    @Override
    public PackageClass getPackageClass() {
        return this.astType.getPackageClass();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ASTType)) {
            return false;
        }
        ASTType that = (ASTType)o;
        return new EqualsBuilder().append((Object)this.getName(), (Object)that.getName()).append(this.getGenericParameters(), that.getGenericParameters()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getName()).hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('<');
        builder.append(StringUtils.join(this.getGenericParameters(), (String)","));
        builder.append('>');
        return this.getName() + builder.toString();
    }
}

