/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.List;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTConstructor;
import org.androidtransfuse.adapter.ASTField;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.PackageClass;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ASTIntersectionType
implements ASTType {
    private List<ASTType> intersection;

    public ASTIntersectionType(List<ASTType> intersection) {
        this.intersection = intersection;
    }

    @Override
    public ImmutableSet<ASTMethod> getMethods() {
        return ImmutableSet.of();
    }

    @Override
    public ImmutableSet<ASTField> getFields() {
        return ImmutableSet.of();
    }

    @Override
    public ImmutableSet<ASTConstructor> getConstructors() {
        return ImmutableSet.of();
    }

    @Override
    public boolean isConcreteClass() {
        return false;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public ASTType getSuperClass() {
        return null;
    }

    @Override
    public ImmutableSet<ASTType> getInterfaces() {
        return ImmutableSet.of();
    }

    @Override
    public ImmutableList<ASTType> getGenericParameters() {
        return ImmutableList.of();
    }

    @Override
    public boolean inheritsFrom(ASTType type) {
        for (ASTType astType : this.intersection) {
            if (!astType.inheritsFrom(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean extendsFrom(ASTType type) {
        for (ASTType astType : this.intersection) {
            if (!astType.extendsFrom(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean implementsFrom(ASTType type) {
        for (ASTType astType : this.intersection) {
            if (!astType.implementsFrom(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PackageClass getPackageClass() {
        return this.intersection.iterator().next().getPackageClass();
    }

    @Override
    public boolean isAnnotated(Class<? extends Annotation> annotation) {
        return false;
    }

    @Override
    public ImmutableSet<ASTAnnotation> getAnnotations() {
        return ImmutableSet.of();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotation) {
        return null;
    }

    @Override
    public ASTAnnotation getASTAnnotation(Class<? extends Annotation> annotation) {
        return null;
    }

    @Override
    public String getName() {
        return Joiner.on((String)"&").join(this.intersection);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ASTIntersectionType)) {
            return false;
        }
        ASTIntersectionType that = (ASTIntersectionType)o;
        return new EqualsBuilder().append(this.intersection, that.intersection).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.intersection).hashCode();
    }
}

