/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import org.androidtransfuse.TransfuseAdapterException;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTConstructor;
import org.androidtransfuse.adapter.ASTField;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.PackageClass;
import org.apache.commons.lang.builder.EqualsBuilder;

public class ASTTypeVirtualProxy
implements ASTType {
    private final PackageClass packageClass;
    private ASTType proxy;

    public ASTTypeVirtualProxy(PackageClass packageClass) {
        this.packageClass = packageClass;
    }

    public void load(ASTType proxy) {
        this.proxy = proxy;
    }

    private ASTType getProxy() {
        if (this.proxy != null) {
            return this.proxy;
        }
        throw new TransfuseAdapterException("Proxy not initialized prior to use");
    }

    @Override
    public ImmutableSet<ASTMethod> getMethods() {
        return this.getProxy().getMethods();
    }

    @Override
    public boolean isFinal() {
        return this.getProxy().isFinal();
    }

    @Override
    public ImmutableSet<ASTField> getFields() {
        return this.getProxy().getFields();
    }

    @Override
    public ImmutableSet<ASTConstructor> getConstructors() {
        return this.getProxy().getConstructors();
    }

    @Override
    public boolean isConcreteClass() {
        return this.getProxy().isConcreteClass();
    }

    @Override
    public boolean isInterface() {
        return this.getProxy().isInterface();
    }

    @Override
    public boolean isEnum() {
        return this.getProxy().isEnum();
    }

    @Override
    public ASTType getSuperClass() {
        return this.getProxy().getSuperClass();
    }

    @Override
    public ImmutableSet<ASTType> getInterfaces() {
        return this.getProxy().getInterfaces();
    }

    @Override
    public ImmutableList<ASTType> getGenericParameters() {
        return this.getProxy().getGenericParameters();
    }

    @Override
    public boolean inheritsFrom(ASTType type) {
        return this.getProxy().inheritsFrom(type);
    }

    @Override
    public boolean extendsFrom(ASTType type) {
        return this.getProxy().extendsFrom(type);
    }

    @Override
    public boolean implementsFrom(ASTType type) {
        return this.getProxy().implementsFrom(type);
    }

    @Override
    public boolean isAnnotated(Class<? extends Annotation> annotation) {
        return this.getProxy().isAnnotated(annotation);
    }

    @Override
    public ImmutableSet<ASTAnnotation> getAnnotations() {
        return this.getProxy().getAnnotations();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotation) {
        return this.getProxy().getAnnotation(annotation);
    }

    @Override
    public ASTAnnotation getASTAnnotation(Class<? extends Annotation> annotation) {
        return this.getProxy().getASTAnnotation(annotation);
    }

    @Override
    public String getName() {
        return this.packageClass.getCanonicalName();
    }

    @Override
    public PackageClass getPackageClass() {
        return this.packageClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ASTType)) {
            return false;
        }
        ASTType that = (ASTType)o;
        return new EqualsBuilder().append((Object)this.proxy, (Object)that).isEquals();
    }

    public int hashCode() {
        return this.proxy != null ? this.proxy.hashCode() : 0;
    }
}

