/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTConstructor;
import org.androidtransfuse.adapter.ASTField;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTParameter;
import org.androidtransfuse.adapter.ASTStringType;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.MethodSignature;

public final class ASTUtils {
    private static final ASTType OBJECT_TYPE = new ASTStringType(Object.class.getCanonicalName());
    private static final ASTUtils INSTANCE = new ASTUtils();

    private ASTUtils() {
    }

    public static ASTUtils getInstance() {
        return INSTANCE;
    }

    public boolean inherits(ASTType astType, ASTType inheritable, boolean implement, boolean extend) {
        if (astType == null) {
            return false;
        }
        if (astType.equals(inheritable)) {
            return true;
        }
        if (implement) {
            for (ASTType typeInterfaces : astType.getInterfaces()) {
                if (!this.inherits(typeInterfaces, inheritable, implement, extend)) continue;
                return true;
            }
        }
        if (extend && inheritable.equals(OBJECT_TYPE)) {
            return true;
        }
        return extend && this.inherits(astType.getSuperClass(), inheritable, implement, extend);
    }

    public ASTAnnotation getAnnotation(Class annotationClass, ImmutableSet<ASTAnnotation> annotations) {
        return this.getAnnotation(annotationClass.getCanonicalName(), annotations);
    }

    public ASTAnnotation getAnnotation(String annotationClassName, ImmutableSet<ASTAnnotation> annotations) {
        for (ASTAnnotation astAnnotation : annotations) {
            if (!astAnnotation.getASTType().getName().equals(annotationClassName)) continue;
            return astAnnotation;
        }
        return null;
    }

    public boolean isAnnotated(ASTType type, Class annotationClass) {
        return this.isAnnotated(type, annotationClass.getCanonicalName());
    }

    public boolean isAnnotated(ASTType type, String annotationClassName) {
        return this.getAnnotation(annotationClassName, type.getAnnotations()) != null;
    }

    public ASTConstructor findConstructor(ASTType type, ASTType ... parameters) {
        ASTConstructor foundConstructor = null;
        for (ASTConstructor astConstructor : type.getConstructors()) {
            if (!this.parameterTypesMatch(astConstructor.getParameters(), parameters)) continue;
            foundConstructor = astConstructor;
        }
        return foundConstructor;
    }

    public boolean constructorExists(ASTType type, final ASTType ... parameters) {
        return FluentIterable.from(type.getConstructors()).anyMatch((Predicate)new Predicate<ASTConstructor>(){

            public boolean apply(ASTConstructor constructor) {
                return ASTUtils.this.parameterTypesMatch(constructor.getParameters(), parameters);
            }
        });
    }

    public ASTMethod findMethod(ASTType containingType, String methodName, ASTType[] methodParameters) {
        MethodSignature matchingSignature = new MethodSignature(methodName, methodParameters);
        for (ASTMethod astMethod : containingType.getMethods()) {
            if (!new MethodSignature(astMethod).equals(matchingSignature)) continue;
            return astMethod;
        }
        return null;
    }

    public boolean methodExists(ASTType containingType, String methodName, ASTType[] methodParameters) {
        final MethodSignature matchingSignature = new MethodSignature(methodName, methodParameters);
        return FluentIterable.from(containingType.getMethods()).transform((Function)new Function<ASTMethod, MethodSignature>(){

            public MethodSignature apply(ASTMethod astMethod) {
                return new MethodSignature(astMethod);
            }
        }).anyMatch((Predicate)new Predicate<MethodSignature>(){

            public boolean apply(MethodSignature methodSignature) {
                return methodSignature.equals(matchingSignature);
            }
        });
    }

    public ASTField findField(ASTType containingType, String fieldName) {
        for (ASTField astField : containingType.getFields()) {
            if (!astField.getName().equals(fieldName)) continue;
            return astField;
        }
        return null;
    }

    public boolean fieldExists(ASTType containingType, final String fieldName) {
        return FluentIterable.from(containingType.getFields()).anyMatch((Predicate)new Predicate<ASTField>(){

            public boolean apply(ASTField astField) {
                return astField.getName().equals(fieldName);
            }
        });
    }

    public boolean parameterTypesMatch(List<ASTParameter> parameters, ASTType[] types) {
        boolean matches = true;
        if (parameters.size() == types.length) {
            for (int i = 0; i < parameters.size(); ++i) {
                if (parameters.get(i).getASTType().equals(types[i])) continue;
                matches = false;
            }
        } else {
            matches = false;
        }
        return matches;
    }
}

