/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class PackageClass {
    private static final String DOT_JAVA = ".java";
    private final String pkg;
    private final String fileName;

    protected PackageClass(String fullyQualifiedName) {
        String processedName = this.removeDotJava(fullyQualifiedName);
        int dotIndex = processedName.lastIndexOf(46);
        if (dotIndex == -1) {
            this.pkg = null;
            this.fileName = this.removeDotJava(processedName);
        } else {
            this.pkg = processedName.substring(0, dotIndex);
            this.fileName = this.removeDotJava(processedName.substring(dotIndex + 1));
        }
    }

    public PackageClass(String pkg, String fileName) {
        this.pkg = pkg;
        this.fileName = this.removeDotJava(fileName);
    }

    public PackageClass(Class<?> inputClass) {
        String canonicalName = inputClass.getCanonicalName();
        if (inputClass.getPackage() != null) {
            this.pkg = inputClass.getPackage().getName();
            this.fileName = canonicalName != null ? canonicalName.substring(this.pkg.length() + 1) : inputClass.getName().substring(inputClass.getPackage().getName().length() + 1).replace('$', '.');
        } else {
            this.fileName = canonicalName;
            this.pkg = null;
        }
    }

    private String removeDotJava(String input) {
        if (input.endsWith(DOT_JAVA)) {
            return input.substring(0, input.length() - DOT_JAVA.length());
        }
        return input;
    }

    public String getClassName() {
        return this.removeDotJava(this.fileName).replace('.', '$');
    }

    public String getFullyQualifiedName() {
        if (StringUtils.isEmpty((String)this.pkg)) {
            return this.getClassName();
        }
        return this.pkg + "." + this.getClassName();
    }

    public String getPackage() {
        return this.pkg == null ? "" : this.pkg;
    }

    public PackageClass append(String addName) {
        return new PackageClass(this.pkg, this.fileName + addName);
    }

    public PackageClass prepend(String prepend) {
        return new PackageClass(this.pkg, prepend + this.fileName);
    }

    public PackageClass replaceName(String replacement) {
        return new PackageClass(this.pkg, replacement);
    }

    public String toString() {
        return this.getCanonicalName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PackageClass)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PackageClass rhs = (PackageClass)obj;
        return new EqualsBuilder().append((Object)this.fileName, (Object)rhs.fileName).append((Object)this.pkg, (Object)rhs.pkg).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.fileName).append((Object)this.fileName).hashCode();
    }

    public String getCanonicalName() {
        if (this.pkg == null) {
            return this.fileName;
        }
        return this.pkg + "." + this.fileName;
    }

    public PackageClass replacePackage(String inputPackage) {
        return new PackageClass(inputPackage, this.fileName);
    }
}

