/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter.classes;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import org.androidtransfuse.TransfuseAdapterException;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.classes.ASTClassFactory;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ASTClassAnnotation
implements ASTAnnotation {
    private final Annotation annotation;
    private final ASTType type;
    private final ASTClassFactory astClassFactory;

    public ASTClassAnnotation(Annotation annotation, ASTType type, ASTClassFactory astClassFactory) {
        this.annotation = annotation;
        this.astClassFactory = astClassFactory;
        this.type = type;
    }

    @Override
    public ImmutableSet<String> getPropertyNames() {
        return FluentIterable.from(Arrays.asList(this.annotation.annotationType().getDeclaredMethods())).transform((Function)new MethodNameExtractor()).toSet();
    }

    @Override
    public <T> T getProperty(String name, Class<T> type) {
        try {
            Method annotationParameter = this.annotation.annotationType().getDeclaredMethod(name, new Class[0]);
            Class<Object> convertedType = type;
            boolean convertToASTType = false;
            boolean convertToASTTypeArray = false;
            boolean convertToASTAnnotation = false;
            boolean convertToASTAnnotationArray = false;
            if (type.equals(ASTType.class)) {
                convertedType = Class.class;
                convertToASTType = true;
            }
            if (type.equals(ASTType[].class)) {
                convertedType = Class[].class;
                convertToASTTypeArray = true;
            }
            if (type.equals(ASTAnnotation.class)) {
                convertedType = Annotation.class;
                convertToASTAnnotation = true;
            }
            if (type.equals(ASTAnnotation[].class)) {
                convertedType = Annotation[].class;
                convertToASTAnnotationArray = true;
            }
            if (!convertedType.isAssignableFrom(annotationParameter.getReturnType())) {
                throw new TransfuseAdapterException("Type not expected: " + convertedType);
            }
            Object invocationResult = annotationParameter.invoke((Object)this.annotation, new Object[0]);
            if (convertToASTType) {
                return (T)this.astClassFactory.getType((Class)invocationResult);
            }
            if (convertToASTTypeArray) {
                ASTType[] astTypes = new ASTType[((Class[])invocationResult).length];
                for (int i = 0; i < ((Class[])invocationResult).length; ++i) {
                    astTypes[i] = this.astClassFactory.getType(((Class[])invocationResult)[i]);
                }
                return (T)astTypes;
            }
            if (convertToASTAnnotation) {
                return (T)this.astClassFactory.getAnnotation((Annotation)invocationResult);
            }
            if (convertToASTAnnotationArray) {
                ASTAnnotation[] astTypes = new ASTAnnotation[((Annotation[])invocationResult).length];
                for (int i = 0; i < ((Annotation[])invocationResult).length; ++i) {
                    astTypes[i] = this.astClassFactory.getAnnotation(((Annotation[])invocationResult)[i]);
                }
                return (T)astTypes;
            }
            return (T)invocationResult;
        }
        catch (IllegalAccessException e) {
            throw new TransfuseAdapterException("IllegalAccessException Exception while accessing annotation method: " + name, e);
        }
        catch (NoSuchMethodException e) {
            throw new TransfuseAdapterException("Annotation method not present: " + name, e);
        }
        catch (InvocationTargetException e) {
            throw new TransfuseAdapterException("InvocationTargetException Exception while accessing annotation method: " + name, e);
        }
    }

    @Override
    public ASTType getASTType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ASTAnnotation)) {
            return false;
        }
        ASTAnnotation that = (ASTAnnotation)o;
        if (!this.type.equals(that.getASTType())) {
            return false;
        }
        HashMap<String, Object> thisProperties = new HashMap<String, Object>();
        HashMap<String, Object> thatProperties = new HashMap<String, Object>();
        for (String property : this.getPropertyNames()) {
            thisProperties.put(property, this.getProperty(property, Object.class));
            thatProperties.put(property, that.getProperty(property, Object.class));
        }
        return thisProperties.equals(thatProperties);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.type).hashCode();
    }

    private static final class MethodNameExtractor
    implements Function<Method, String> {
        private MethodNameExtractor() {
        }

        public String apply(Method input) {
            return input.getName();
        }
    }
}

